import java.awt.*;
//import static java.lang.Math.random;
//import static java.lang.Math.round;

public class AVLNode extends BSTNode {
  int bal=0;
  public AVLNode (DataStructure D, int key, int x, int y) { super (D, key, x, y); }
  public AVLNode (DataStructure D, int key) { this (D, key, -10, -10); }
  public AVLNode (BSTNode v) { this (v.D, v.key, v.x, v.y); }

  public int balance() {
    int l = (left == null) ? 0 : left.height,
        r = (right == null) ? 0 : right.height;
    return bal = r - l;
  }

  public void calc() {
    super.calc();
    balance();
  }

  public void draw (Graphics g) {
    drawBg (g);

    int xx=x-D.radius, yy=y-D.radius, dx=2*D.radius, dy=2*D.radius;
    String b="";
    if (bgcolor == Node.NORMAL) {
      g.setColor (Color.ORANGE);
      switch (bal) {
        case +2: b = "++";     g.fillArc (xx, yy, dx, dy, 270, 180); break;
        case +1: b = "+";      g.fillArc (xx, yy, dx, dy, 210, 180); break;
         case 0: b = "\u00b7"; g.fillArc (xx, yy, dx, dy, 180, 180); break;
        case -1: b = "-";      g.fillArc (xx, yy, dx, dy, 150, 180); break;
        case -2: b = "--";     g.fillArc (xx, yy, dx, dy,  90, 180); break;
      }
      g.setColor (fgcolor);
      g.drawOval (x-D.radius, y-D.radius, 2*D.radius, 2*D.radius);
    }

    if (D.M.small) {
      Font font = new Font("Helvetica", Font.PLAIN, 9);
      FontMetrics fm = g.getFontMetrics(font);
      g.setColor (fgcolor);
      g.setFont (font);
      g.drawString (b, x-fm.stringWidth(b)/2, y-fm.getHeight()/2+fm.getAscent()-1);
    } else {
      drawKey (g);
      Font font = new Font("Helvetica", Font.PLAIN, 9);
      FontMetrics fm = g.getFontMetrics(font);
      g.setFont(font);
      g.drawString(b, x+D.radius-2, y-D.radius+2);
    }
  }

  /*  public void linkleft(TreapNode v) { left = v; v.parent = this; }
  public void linkright(TreapNode v) { right = v; v.parent = this; }*/
}
