import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class Buttons extends JPanel implements ActionListener {
  main M;
  DataStructure D;
  int numButtons, numInputs;
  JTextField I;
  JButton[] B; 
  JButton next, clear, random;
  JCheckBox pause, small;
  JLabel stats;

  public Buttons(main M) {
    this.M = M; D = M.D; 
    assert D != null : "data structure not initialized yet";

    I = new JTextField(5);
    B = new JButton[numButtons=D.getNumButtons()];

    // first
    JPanel first = new JPanel();
    first.setLayout (new FlowLayout());

    first.add(I);
    I.addActionListener(this);

    for (int i=0; i<numButtons; ++i) {
      first.add(B[i] = D.getButton(i));
      B[i].setEnabled(true);
      B[i].addActionListener(this);
    }

    first.add(next = new JButton(M.msg.getString ("next")));
    next.setMnemonic(KeyEvent.VK_N);
    next.setEnabled(false);
    next.addActionListener(this);

    // second
    JPanel second = new JPanel();
    second.setLayout (new FlowLayout());
    pause = new JCheckBox (M.msg.getString ("pause"), true);
    pause.setMnemonic (KeyEvent.VK_P);
    pause.addActionListener (this);
    second.add (pause);

    small = new JCheckBox (M.msg.getString ("small"), false);
    small.setMnemonic (KeyEvent.VK_S);
    small.addActionListener (this);
    second.add (small);

    D.otherButtons (second);

    clear = new JButton (M.msg.getString ("clear"));
    clear.setMnemonic (KeyEvent.VK_C);
    clear.addActionListener (this);
    second.add (clear);

    random = new JButton (M.msg.getString ("random"));
    random.setMnemonic (KeyEvent.VK_R);
    random.addActionListener (this);
    second.add (random);

    stats = new JLabel (D.stats());
    JPanel third = new JPanel();
    third.setLayout (new FlowLayout());
    third.add (stats);

    setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
    add (first);
    add (second);
    add (third);
    setBorder(BorderFactory.createCompoundBorder(
        BorderFactory.createTitledBorder(M.msg.getString ("control")), 
    BorderFactory.createEmptyBorder(5,5,5,5)));
  }

  public void actionPerformed (ActionEvent evt) {
    if (evt.getSource() == next) {
      D.next();
      //repaint();
    } else if (evt.getSource() == clear) {
      D.clear();
      //repaint();
    } else if (evt.getSource() == random) {
      int n = 10;
      StringTokenizer st = new StringTokenizer (I.getText());
      try { 
        n = Integer.parseInt (st.nextToken());
      } catch (Exception e) {}
      finally {
        if (n < 1) n = 1;
        if (n > 99) n = 99;
      }
      Vector<Integer> args = new Vector<Integer>(n);
      Random g = new Random(System.currentTimeMillis());
      boolean p = M.pause;
      M.pause = false;
      for (int i=0; i<n; ++i) args.add (g.nextInt(100));
      D.action(0, args);
      M.pause = p;
    } else if (evt.getSource() == pause) {
      M.pause = pause.isSelected();
    } else if (evt.getSource() == small) {
      M.small = small.isSelected();
      D.resize();
    } else {
      for (int i=0; i<numButtons; ++i)
        if (evt.getSource() == B[i]) {
          Vector<Integer> args = new Vector<Integer>();
          StringTokenizer st = new StringTokenizer (I.getText());
          while (st.hasMoreTokens()) {
            try {
              int x = Integer.parseInt(st.nextToken());
              if (x < 0) x = 0;
              if (x > 99) x = 99;
              args.add (x);
            } catch (NumberFormatException e) {}
          }
          enableNext();
          final int fi = i;
          final Vector<Integer> fargs = args;
          Thread t = new Thread (new Runnable() {
            public void run() { D.action(fi, fargs); }
          });
          t.start();
          break;
        }
    }
  }

  public void enableNext() {
    for (int i=0; i<numButtons; ++i) B[i].setEnabled (false);
    clear.setEnabled (false);
    random.setEnabled (false);
    next.setEnabled(true);
  }

  public void disableNext() {
    for (int i=0; i<numButtons; ++i) B[i].setEnabled (true);
    clear.setEnabled (true);
    random.setEnabled (true);
    next.setEnabled (false);
  }

  public void setStats (String s) {
    stats.setText (s);
  }
}

