import java.awt.*;

public class Heap extends PriorityQueue {
  int n = 0;
  BSTNode root = null, v = null, v2 = null;

  public Heap (main M) { super (M); }

  public void insert (int x) { start (new HeapInsert (this, x)); }
  public void delete() { start (new HeapDelete (this)); }
  public void clear() { root = null; n = 0; setStats(); }
  public void clean() { v = v2 = null; }

  public String stats() {
    if (n == 0) return "Size: 0 (heap is empty)";
    else if (n == 100) return "Size: 100 (heap is full)";
    else return "Size: "+n;
  }

  public void draw (Graphics g) {
    if (root != null) { root.moveTree(); root.drawTree(g); }
    if (v != null) { v.move(); v.draw(g); }
    if (v2 != null) { v2.move(); v2.draw(g); }
  }

  public void resize () {
    if (M.small) {
      radius = 5;
      xspan = 5;
      yspan = 2;
      fontsize = 5;
    } else {
      radius = 10;
      xspan = 15;
      yspan = 5;
      fontsize = 11;
    }
    swidth = M.S.size.width;
    sheight = M.S.size.height;
    rootx = swidth/2;
    rooty = 5*radius + yspan;
    if (root != null) reposition();
  }

  public void reposition () { if (root != null) root._reposition (); }
}
