import java.awt.*;

public class Node {
  DataStructure D;
  int key;
  static final int INF = 99999, NOKEY = -1, NULL = 100000;
  int x, y, tox, toy, steps;
  boolean marked = false;

  Color fgcolor, bgcolor;
  static final Color NORMAL = Color.yellow;
  static final Color INSERT = new Color (0x2b65ec);
  static final Color FIND = Color.lightGray;
  static final Color FOUND = Color.green;
  static final Color NOTFOUND = Color.red;
  static final Color DELETE = Color.red;

  public Node(){}
  public Node (DataStructure D, int key, int x, int y) {
    this.D = D; this.key = key; this.x = tox = x; this.y = toy = y; steps = 0;
    setColor (Color.black, NORMAL);
  }
  public Node (DataStructure D, int key) { this (D, key, -10, -10); }
  public Node (Node v) { this (v.D, v.key, v.x, v.y); }

  public void setColor (Color fg, Color bg) { fgcolor = fg; bgcolor = bg; }
  public void fgColor (Color fg) { fgcolor = fg; }
  public void bgColor (Color bg) { bgcolor = bg; }

  public void mark() { marked = true; }
  public void unmark() { marked = false; }

  public void drawBg (Graphics g) {
    g.setColor (bgcolor);
    g.fillOval (x-D.radius, y-D.radius, 2*D.radius, 2*D.radius);
    g.setColor (fgcolor);
    g.drawOval (x-D.radius, y-D.radius, 2*D.radius, 2*D.radius);
    if (marked) 
      g.drawOval (x-D.radius-2, y-D.radius-2, 2*D.radius+4, 2*D.radius+4);
  }

  public void drawKey (Graphics g) {
    g.setColor (fgcolor);
    if (key != NOKEY) {
      Font font = new Font("Helvetica", Font.PLAIN, D.fontsize);
      FontMetrics fm = g.getFontMetrics(font);
      String str = ""+key;
      if (key == INF) str = "\u221e";
      if (key == -INF) str = "-\u221e";
      g.setFont(font);
      g.drawString(str, x-fm.stringWidth(str)/2, 
                        y-fm.getHeight()/2+fm.getAscent());
    }
  }

  public void draw (Graphics g) {
    if (key != NULL) {
      drawBg (g);
      drawKey (g);
    }
  }

  public void goTo (int tox, int toy) {
    this.tox = tox; this.toy = toy; steps = D.M.STEPS;
  }
  public void goTo (Node v) { goTo (v.tox, v.toy); }

//  public void goAbove (int tox, int toy) { goTo (tox, toy - 2*D.radius - D.yspan); }
  public void goAbove (Node v) { goTo (v.tox, v.toy - 2*D.radius - D.yspan); }
//  public void goNextTo (int tox, int toy) { goTo (tox + 2*D.radius + D.xspan, toy); }
  public void goNextTo (Node v) { goTo (v.tox + 2*D.radius + D.xspan, v.toy); }

  public void goToRoot() { goTo (D.rootx, D.rooty); }
  public void goAboveRoot() { goTo (D.rootx, D.rooty - 2*D.radius - D.yspan); }
  public void goDown() { goTo (tox, D.sheight+3*D.radius); }
  public void goLeft() { goTo (-D.radius, D.sheight+3*D.radius); }
  public void goRight() { goTo (D.swidth+D.radius, D.sheight+3*D.radius); }

  public void move() {
    if (steps > 0) {
      x += (tox-x)/steps;
      y += (toy-y)/steps;
      --steps;
    }
  }
}
