import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Screen extends JPanel implements Runnable {
  // obrazovka (ak nie je suspendnuta) neustale vykresluje poziciu
  Thread t = null;
  boolean suspended;
  DataStructure D = null;
  
  Image I;
  Graphics G;
  Dimension size;

  public void setDS (DataStructure D) { this.D = D; }
  
  void check_size() {
    Dimension d = getSize();
    if (I == null || d.width != size.width || d.height != size.height) {
      I = createImage (d.width, d.height);
      G = I.getGraphics ();
      size = d;
      D.resize();
    }
  }

  void clear () {
    G.setColor (Color.white);
    G.fillRect (0, 0, size.width, size.height);
  }
 
  public void paint (Graphics g) {
    check_size ();
    clear ();
    if (D != null) D.draw (G);
    else System.out.println ("[DS null !]");
    g.drawImage (I, 0, 0, null);
//    System.out.println ("screen paint");
  }

  public void suspend () { suspended = true; }
  public void resume () { 
    if (suspended) { 
      suspended = false;
      synchronized (this) { notify (); }
    }
  }

  public void start() {
    if (t == null) {
      t = new Thread (this);
      suspended = false;
      t.start();
    }
  }

  public void run() {
//    repaint();
    try {
      while (true) {
        if (suspended)
          synchronized (this) {
            while (suspended) { wait (); }
          }
        repaint ();
        Thread.sleep (50);
      }
    } catch (InterruptedException e) { }
  }
}

