import java.awt.*;

public class SplayDelete extends Algorithm {
  Splay T;
  BSTNode s;
  int K;

  public SplayDelete (Splay T, int x) {
    super (T.M);
    this.T = T;
    T.v = s = new SplayNode (T, K=x);
    s.bgColor (Node.FIND);
    setHeader ("splay");
  }

  public void run() {
    if (T.root == null) {
      s.goToRoot();
      setText ("empty");
      mysuspend();
      s.goDown();
      s.bgColor (Node.NOTFOUND);
      setText ("notfound");
      return;
    }

    BSTNode w = T.root;
    s.goTo (w);
    setText ("splaystart");
    mysuspend();
    while (true) {
      if (w.key == K) break;
      else if (w.key < K) { // right
        if (w.right == null) break;
        w = w.right;
        setText ("bstfindright", K, w.key);
      } else { // left
        if (w.left == null) break;
        w = w.left;
        setText ("bstfindleft", K, w.key);
      }
      s.goTo (w);
      mysuspend();
    }
    w.bgColor (Node.FIND);
    T.v = null;
    setText ("splayfound");
    mysuspend();

    // splay
    while (!w.isRoot()) {
      if (w.parent.isRoot()) {
        T.rotate (w);
        setText ("splayroot");
      } else {
        if (w.isLeft() == w.parent.isLeft()) {
          if (w.isLeft()) setText ("splayzigzigleft");
                     else setText ("splayzigzigright");
          T.rotate (w.parent); mysuspend();
          T.rotate (w);
        } else {
          if (!w.isLeft()) setText ("splayzigzagleft");
                      else setText ("splayzigzagright");
          T.rotate (w); mysuspend();
          T.rotate (w);
        }
      }
      mysuspend();
    }
    T.root = w;

    setHeader ("deletion");
    w.bgColor (Node.NORMAL);

    if (w.key != s.key) {
      setText ("notfound");
      s.bgColor (Node.NOTFOUND);
      s.goDown();
      return;
    }

    T.v = w; T.v.goDown(); T.v.bgColor (Node.DELETE);
    if (w.left == null) {
      setText ("splaydeleteright");
      T.root = w.right; T.root.parent = null;
      T.reposition();
      mysuspend();
    } else if (w.right == null) {
      setText ("splaydeleteleft");
      T.root = w.left; T.root.parent = null;
      T.reposition();
      mysuspend();
    } else {
      setText ("splaydelete");
      T.root2 = w.left; T.root2.parent = null;
      T.root = w.right; T.root.parent = null;
      T.vv = s = new SplayNode (T, -Node.INF);
      s.bgColor (Node.FIND);
      w = w.right; s.goTo(w); mysuspend();
      while (w.left != null) {
        w = w.left; s.goTo(w); mysuspend();
      }
      w.bgColor (Node.FIND);
      T.vv = null;
      // splay
      while (!w.isRoot()) {
        if (w.parent.isRoot()) {
          T.rotate2 (w);
          //setText ("splayroot");
        } else {
          if (w.isLeft() == w.parent.isLeft()) {
            /*if (w.isLeft()) setText ("splayzigzigleft");
                       else setText ("splayzigzigright");*/
            T.rotate2 (w.parent); mysuspend();
            T.rotate2 (w);
          } else {
            /*if (!w.isLeft()) setText ("splayzigzagleft");
                        else setText ("splayzigzagright");*/
            T.rotate2 (w); mysuspend();
            T.rotate2 (w);
          }
        }
        mysuspend();
      }
      setText ("splaydeletelink");
      T.root = w; w.bgColor (Node.NORMAL);
      w.linkleft (T.root2);
      T.root2 = null;
      T.reposition();
      mysuspend();
    }

    setText ("done");
    T.vv = null;
  }
}

