import re

# LibreOffice document
LibreOffice = re.compile("^application/vnd\.oasis\.opendocument\.(text|spreadsheet|presentation)$")

# Portable Document Format
PDF = re.compile("^application/pdf$")

# Example of various executable programs
executable = re.compile("^(application/x-ms.*|application/x-ms-installer|application/x-elf|application/x-sh|"
                        "text/x-perl|text/x-python)|java")

# Matches any file
any_type = re.compile(".*")

# Images
image = re.compile("^image/.*")

# Microsoft Office documents
office = re.compile("^application/(vnd\.openxmlformats-officedocument.*|msword.*|.*excel.*|.*powerpoint.*)")
