#include "StdAfx.h"
#include "AFractalDlg.h"
#include "CControlFractal.h"
#include "CControlPreview.h"
#include "CControlMand.h"
#include "CControlMandNURBS.h"
#include "CControlJulia.h"
#include "CControlAnim.h"
#include "CControlColor.h"
#include "CControlPalette.h"
#include "CControlPaletteSlider.h"
#include "CAnimationPath.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "CExpAnimObject.h"
#include "CMoveAnimObject.h"
#include "CJuliaAnimObject.h"
#include "resource.h"
#include "stdio.h"
#include <string>
#include <sstream>
#include "commctrl.h"
#include "commdlg.h"
#include "process.h"
#include <limits>
#include <iomanip>
#include <sstream>
#include <iostream>
#include "CThreadManager.h"
#include "CTimer.h"

#define WM_NEXTFRAME		WM_APP + 0x160
#define WM_CALCUPDATE		WM_APP + 0x161
#define WM_UPDATEPOSITION	WM_APP + 0x162
#define WM_CALCDONE			WM_APP + 0x163
#define WM_UPDATERANGE		WM_APP + 0x164
#define WM_PREVIEW_REFRESH	WM_APP + 0x165

#define CHECK_ANIM_JULIA	1
#define CHECK_ANIM_EXP		2
#define CHECK_ANIM_MOVE		3

const char m_className[] = "myWindowClass";

int threadsFinished = 0;
bool initialCalc = false;

HWND g_hwnd;
HWND hwndStatusBar;
HINSTANCE instance;
HMENU menuMand;
HMENU menuJulia;

CThreadManager *threadManager;
CTimer *timer;

CControlColor* colors[14];
CControlPalette *paletteControl;
CControlPaletteSlider *paletteSliderControl;
CControlFractal *fractalControl;
CControlPreview *previewControl;
CControlMand *leftWindow = NULL;
CControlMandNURBS *leftWindowNURBS = NULL;
CControlJulia *rightWindow = NULL;
CControlAnim *fractalControlAnim = NULL;
CAnimObject *animationObject = NULL;
CNURBS *juliaNURBSObject = NULL;

CFractal *renderedImage;
CMandelbrot *defaultMandBig;
CMandelbrot *defaultMandSmall;
CAnimationPath *path = NULL;

std::stringstream strX;
std::stringstream strY;
std::stringstream strSeedX;
std::stringstream strSeedY;
std::stringstream strZoom;
std::stringstream strIter;
std::stringstream strExp;

std::stringstream strNumFrames;
std::stringstream strFPS;
std::stringstream strStartExp;
std::stringstream strEndExp;
std::stringstream strStepFrames;

std::stringstream strStepFrameCount;
std::stringstream strFPSmove;
std::stringstream strStepCount;

std::stringstream strProgress;

std::stringstream strIndex;
std::stringstream strInc;

char resolution = 1;				// 0 - 800x600
									// 1 - 1024x768
									// 2 - 1280x1024

long double zoom;
int iterations;
long double mexp;
long double x = 1;
long double y = 1;
long double seedX = 0.6;
long double seedY = 0.4;
bool customRes;
int custWidth;
int custHeight;

bool recordFullPath = false;
int animCurrentFrame = 0;
int video_quality;

bool animPlaying = false;

/* counter for computation of animations, each thread updates 10 times its status,  */
/* this variable is incremented and progress bar is updated                         */
int progressBar = 0;

int quality = 1;
float computationStatus = 0;

bool animationReady = false;
bool computing = false;
bool realtime = false;			// realtime preview of palette colors
bool smoothPreview = false;

char changedByApp = 0;

unsigned char *customPaletteJulia;
unsigned char *customPaletteMand;
int customPaletteSizeJulia;
int customPaletteSizeMand;
double customIndexValueJulia;
double customIndexValueMand;
double customIndexIncJulia;
double customIndexIncMand;

template < typename Float >
unsigned int sig_digits ( Float const & ) {
	return (unsigned int)( - std::log( (long double)std::numeric_limits<Float>::epsilon()));
}

void CreateDefCustomPalettes()
{
	customPaletteSizeMand = 18;
	customPaletteMand = new unsigned char[customPaletteSizeMand];

	customPaletteMand[0] = 0;
	customPaletteMand[1] = 0;
	customPaletteMand[2] = 135;
	customPaletteMand[3] = 176;
	customPaletteMand[4] = 226;
	customPaletteMand[5] = 255;
	customPaletteMand[6] = 255;
	customPaletteMand[7] = 200;
	customPaletteMand[8] = 0;
	customPaletteMand[9] = 125;
	customPaletteMand[10] = 0;
	customPaletteMand[11] = 0;
	customPaletteMand[12] = 0;
	customPaletteMand[13] = 0;
	customPaletteMand[14] = 135;
	customPaletteMand[15] = 0;
	customPaletteMand[16] = 0;
	customPaletteMand[17] = 0;

	customIndexIncMand = 40.0f;
	customIndexValueMand = 20.0f;

	customPaletteSizeJulia = 9;
	customPaletteJulia = new unsigned char[customPaletteSizeJulia];

	customPaletteJulia[0] = 255;
	customPaletteJulia[1] = 255;
	customPaletteJulia[2] = 255;
	customPaletteJulia[3] = 199;
	customPaletteJulia[4] = 21;
	customPaletteJulia[5] = 133;
	customPaletteJulia[6] = 199;
	customPaletteJulia[7] = 21;
	customPaletteJulia[8] = 133;

	customIndexIncJulia = 0.0f;
	customIndexValueJulia = 0.0f;
}

void Run(void *v)
{
	Sleep(1000/animationObject->GetFPS());
	PostMessage((HWND)v, WM_NEXTFRAME, NULL, NULL);
}

void PlayFrame(HWND hwnd)
{
	_beginthread(Run, 0, hwnd);
}

/*	check for all input fields and compare them to animation object settings, if everything match we can play animation,
	if not, we have to compute it */
bool CheckAnimObjectSettings(int type, HWND hwnd)
{
	char tmp[20];
	char tmp2[20];
	
	switch(type)
	{
		case CHECK_ANIM_JULIA:	
			return animationObject != NULL && 
				   animationObject->m_animObjectType == JULIA_ANIM_OBJECT &&
				   ((CJuliaAnimObject*)animationObject)->GetFrameStepCount() == GetDlgItemInt(hwnd, IDC_EDIT_FRAMESTEPS, false, false) &&
				   animationObject->GetQuality() == quality &&
				   ((CJuliaAnimObject*)animationObject)->GetIterationCount() == GetDlgItemInt(hwnd, IDC_EDIT_ITERATIONS, false, false);
		break;
		case CHECK_ANIM_EXP:
			GetDlgItemText(hwnd, IDC_EDIT_STARTEXP, tmp, 20);
			GetDlgItemText(hwnd, IDC_EDIT_ENDEXP, tmp2, 20);
			return animationObject != NULL &&
				   animationObject->m_animObjectType == EXP_ANIM_OBJECT &&
				   animationObject->GetNumFrames() == GetDlgItemInt(hwnd, IDC_EDIT_NUMFRAMES, false, false) &&
				   ((CExpAnimObject*)animationObject)->GetStartExp() == atof(tmp) &&
				   animationObject->GetQuality() == quality &&
				   ((CExpAnimObject*)animationObject)->GetEndExp() == atof(tmp2);
		break;
		case CHECK_ANIM_MOVE:
			return animationObject != NULL &&
				   animationObject->m_animObjectType == MOVE_ANIM_OBJECT &&
				   animationObject->GetQuality() == quality &&
				   animationObject->GetFinishedFrameCount() == (GetDlgItemInt(hwnd, IDC_EDIT_STEPFRAMES, false, false) * (GetDlgItemInt(hwnd, IDC_EDIT_STEPCOUNT, false, false)-1)) &&
				   ((CMoveAnimObject*)animationObject)->GetStepFrameCount() == GetDlgItemInt(hwnd, IDC_EDIT_STEPFRAMES, false, false);
		break;
	}
	return false;
}

bool ValidateDialog(int type, HWND hwnd)
{
	char tmp[20];
	
	switch(type)
	{
		case CHECK_ANIM_JULIA:
			if(GetDlgItemInt(hwnd, IDC_EDIT_FRAMESTEPS, false, false) < 1)
			{
				MessageBox(hwnd, "Invalid number of frames, have to be greater than 0", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
			if(GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false) < 1)
			{
				MessageBox(hwnd, "Invalid number of frames per second, have to be greater than 0", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
			if(GetDlgItemInt(hwnd, IDC_EDIT_ITERATIONS, false, false) < 1)
			{
				MessageBox(hwnd, "Invalid number of iterations, have to be greater than 0", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
		break;
		case CHECK_ANIM_EXP:
			if(GetDlgItemInt(hwnd, IDC_EDIT_NUMFRAMES, false, false) < 1)
			{
				MessageBox(hwnd, "Invalid number of frames, have to be greater than 0", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
			if(GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false) < 1)
			{
				MessageBox(hwnd, "Invalid number of frames per second, have to be greater than 0", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
			
			GetDlgItemText(hwnd, IDC_EDIT_STARTEXP, tmp, 20);
			if(atof(tmp) < 1)
			{
				MessageBox(hwnd, "Invalid value of starting exponent, have to be greater than 1", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
			
			GetDlgItemText(hwnd, IDC_EDIT_ENDEXP, tmp, 20);
			if(atof(tmp) < 1)
			{
				MessageBox(hwnd, "Invalid value of ending exponent, have to be greater than 1", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
		break;
		case CHECK_ANIM_MOVE:
			if(GetDlgItemInt(hwnd, IDC_EDIT_STEPFRAMES, false, false) < 1)
			{
				MessageBox(hwnd, "Invalid number of step frames, have to be greater than 0", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
			if(GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false) < 1)
			{
				MessageBox(hwnd, "Invalid number of frames per second, have to be greater than 0", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
			if(GetDlgItemInt(hwnd, IDC_EDIT_STEPCOUNT, false, false) < 2)
			{
				MessageBox(hwnd, "Invalid number of steps, have to be greater than 2", "Incorrect data", MB_ICONWARNING | MB_OK);
				return false;
			}
		break;
	}
	return true;
}

bool PaletteChanged(double indexVal, double indexInc, int colorCount)
{
	bool changed = fractalControl->GetFractalObject()->GetActualPaletteIndexValue() != indexVal ||
			   fractalControl->GetFractalObject()->GetActualPaletteIncrement() != indexInc ||
			   fractalControl->GetFractalObject()->GetActualPaletteSize()/3 != colorCount;
	if(!changed)
	{
		unsigned char *actualPalette = fractalControl->GetFractalObject()->GetActualPalette();
		for(int i = 0; i < colorCount-1 && !changed; i++)
		{
			changed = actualPalette[3*i] != colors[i+1]->GetR() ||
					  actualPalette[3*i + 1] != colors[i+1]->GetG() ||
					  actualPalette[3*i + 2] != colors[i+1]->GetB();
		}
		if(!changed)
		{
			changed = actualPalette[3*(colorCount-1)] != colors[0]->GetR() ||
					  actualPalette[3*(colorCount-1) + 1] != colors[0]->GetG() ||
					  actualPalette[3*(colorCount-1) + 2] != colors[0]->GetB();
		}
	}
	return changed;
}
void CenterDialog(HWND hwnd)
{
	HWND hwndOwner; 
	RECT rc, rcDlg, rcOwner; 
	// Get the owner window and dialog box rectangles. 

	if ((hwndOwner = GetParent(hwnd)) == NULL) 
	{
		hwndOwner = GetDesktopWindow(); 
	}

	GetWindowRect(hwndOwner, &rcOwner); 
	GetWindowRect(hwnd, &rcDlg); 
	CopyRect(&rc, &rcOwner); 

	// Offset the owner and dialog box rectangles so that right and bottom 
	// values represent the width and height, and then offset the owner again 
	// to discard space taken up by the dialog box. 

	OffsetRect(&rcDlg, -rcDlg.left, -rcDlg.top); 
	OffsetRect(&rc, -rc.left, -rc.top); 
	OffsetRect(&rc, -rcDlg.right, -rcDlg.bottom); 

	// The new position is the sum of half the remaining space and the owner's 
	// original position. 

	SetWindowPos(hwnd, 
				 HWND_TOP, 
				 rcOwner.left + (rc.right / 2), 
				 rcOwner.top + (rc.bottom / 2), 
				 0, 0,          // Ignores size arguments. 
				 SWP_NOSIZE); 
}

BOOL CALLBACK DlgPaletteProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	unsigned char r,g,b,s,v;
	short int h;
	unsigned char *p;

	char tmp[20];
	char tmp2[20];
	
	double newIndexInc;
	double newIndexValue;
	int newColorCount;

	int selectionIndex;

	switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);	
			realtime = false;
			
			for(int i = 0; i < 14; i++)
				colors[i] = new CControlColor(hwnd, i);
	
			paletteControl = new CControlPalette(hwnd);
			paletteSliderControl = new CControlPaletteSlider(hwnd);
			p = fractalControl->GetFractalObject()->GetActualPalette();
			for(int i = 0; i < fractalControl->GetFractalObject()->GetActualPaletteSize()-3; i += 3)
			{
				colors[(i+3)/3]->SetRGB(p[i],p[i+1], p[i+2]);
			}
			colors[0]->SetRGB(p[fractalControl->GetFractalObject()->GetActualPaletteSize()-3],
							  p[fractalControl->GetFractalObject()->GetActualPaletteSize()-2],
							  p[fractalControl->GetFractalObject()->GetActualPaletteSize()-1]);
			colors[1]->SetSelected(true);
			paletteControl->SetRGB(p[0], p[1], p[2]);
			paletteSliderControl->SetRGB(p[0], p[1], p[2]);

			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("3"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("4"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("5"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("6"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("7"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("8"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("9"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("10"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("11"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("12"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("13"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_ADDSTRING, 0, (LPARAM)("14"));

			selectionIndex = fractalControl->GetFractalObject()->GetActualPaletteSize()/3;
			for(int i = 0; i < 14; i++)
				if(i < selectionIndex)
					ShowWindow(colors[i]->GetHandle(), true);
				else
					ShowWindow(colors[i]->GetHandle(), false);

			SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_SETCURSEL, selectionIndex - 3, 0);

			strIndex.str("");
			strInc.str("");

			strInc << fractalControl->GetFractalObject()->GetActualPaletteIncrement();
			strIndex << fractalControl->GetFractalObject()->GetActualPaletteIndexValue();

			SetDlgItemText(hwnd, IDC_EDIT_INDEX_VALUE, strIndex.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_INDEX_INC, strInc.str().c_str());

			{
				int newColorCount = fractalControl->GetFractalObject()->GetActualPaletteSize()/3;
				unsigned char *newPalette = new unsigned char[newColorCount*3];
				for(int i = 0; i < newColorCount - 1; i++)
				{
					newPalette[3*i] = colors[i+1]->GetR();
					newPalette[3*i+1] = colors[i+1]->GetG();
					newPalette[3*i+2] = colors[i+1]->GetB();
				}
				newPalette[3*(newColorCount-1)] = colors[0]->GetR();
				newPalette[3*(newColorCount-1)+1] = colors[0]->GetG();
				newPalette[3*(newColorCount-1)+2] = colors[0]->GetB();

				previewControl = new CControlPreview(hwnd, newPalette, newColorCount*3,
													 fractalControl->GetFractalObject()->GetActualPaletteIndexValue(),
													 fractalControl->GetFractalObject()->GetActualPaletteIncrement(),
													 fractalControl->GetFractalType() == FRACTAL_TYPE_MAND);

				delete [] newPalette;
			}

			SetDlgItemInt(hwnd, IDC_EDIT_PREVIEW_ITER, 64, false);
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDCANCEL:
                    EndDialog(hwnd, IDCANCEL);
                break;
				case IDOK:
					GetDlgItemText(hwnd, IDC_EDIT_INDEX_INC, tmp, 20);
					GetDlgItemText(hwnd, IDC_EDIT_INDEX_VALUE, tmp2, 20);
					newIndexInc = atof(tmp);
					newIndexValue = atof(tmp2);
					newColorCount = SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_GETCURSEL, 0, 0) + 3;

					if(PaletteChanged(newIndexValue, newIndexInc, newColorCount))
					{
						// set custom palette
						fractalControl->GetFractalObject()->SetCustomIndexValue(newIndexValue);
						fractalControl->GetFractalObject()->SetCustomIndexIncrement(newIndexInc);
						
						unsigned char *newPalette = new unsigned char[newColorCount*3];
						for(int i = 0; i < newColorCount - 1; i++)
						{
							newPalette[3*i] = colors[i+1]->GetR();
							newPalette[3*i+1] = colors[i+1]->GetG();
							newPalette[3*i+2] = colors[i+1]->GetB();
						}
						newPalette[3*(newColorCount-1)] = colors[0]->GetR();
						newPalette[3*(newColorCount-1)+1] = colors[0]->GetG();
						newPalette[3*(newColorCount-1)+2] = colors[0]->GetB();

						fractalControl->GetFractalObject()->SetCustomPalette(newPalette, newColorCount*3);
						fractalControl->GetFractalObject()->SetActualPalette(PALETTE_CUSTOM);

						CheckMenuItem(GetMenu(g_hwnd), ID_FRACTAL_PALETTE_1, MF_UNCHECKED);
						CheckMenuItem(GetMenu(g_hwnd), ID_FRACTAL_PALETTE_2, MF_UNCHECKED);
						CheckMenuItem(GetMenu(g_hwnd), ID_FRACTAL_PALETTE_0, MF_CHECKED);

						fractalControl->GetFractalObject()->Compute();

						if(fractalControl->GetFractalType() == FRACTAL_TYPE_MAND)
						{
							memcpy(customPaletteMand, newPalette, newColorCount*3*sizeof(unsigned char));
							customIndexIncMand = newIndexInc;
							customIndexValueMand = newIndexValue;
							customPaletteSizeMand = newColorCount*3;
						}
						else
						{
							memcpy(customPaletteJulia, newPalette, newColorCount*3*sizeof(unsigned char));
							customIndexIncJulia = newIndexInc;
							customIndexValueJulia = newIndexValue;
							customPaletteSizeJulia = newColorCount*3;
						}
						delete [] newPalette;
					}
					EndDialog(hwnd, IDOK);
				break;
				case IDC_EDIT_H:
				case IDC_EDIT_S:
				case IDC_EDIT_V:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(changedByApp > 0)
						{
							changedByApp--;
							return 1;
						}
						h = GetDlgItemInt(hwnd, IDC_EDIT_H, false, false);
						s = GetDlgItemInt(hwnd, IDC_EDIT_S, false, false);
						v = GetDlgItemInt(hwnd, IDC_EDIT_V, false, false);
						paletteSliderControl->SetHSV(h, s, v);
						paletteControl->SetHSV(h, s, v);
						for(int i = 0; i < 14; i++)
						{
							if(colors[i]->GetSelected())
							{
								colors[i]->SetHSV(h, s, v);
								InvalidateRect(colors[i]->GetHandle(), NULL, false);
								break;
							}
						}
						if(realtime)
						{
							SendMessage(hwnd, WM_PREVIEW_REFRESH, 0, 0);
						}
						return 0;
					}
				break;
				case IDC_EDIT_R:
				case IDC_EDIT_G:
				case IDC_EDIT_B:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(changedByApp > 0)
						{
							changedByApp--;
							return 1;
						}
						r = GetDlgItemInt(hwnd, IDC_EDIT_R, false, false);
						g = GetDlgItemInt(hwnd, IDC_EDIT_G, false, false);
						b = GetDlgItemInt(hwnd, IDC_EDIT_B, false, false);
						paletteSliderControl->SetRGB(r, g, b);
						paletteControl->SetRGB(r, g, b);
						for(int i = 0; i < 14; i++)
						{
							if(colors[i]->GetSelected())
							{
								colors[i]->SetRGB(r, g, b);
								InvalidateRect(colors[i]->GetHandle(), NULL, false);
								break;
							}
						}
						if(realtime)
						{
							SendMessage(hwnd, WM_PREVIEW_REFRESH, 0, 0);
						}

						return 0;
					}
				break;
				case IDC_COMBO_COLORCOUNT:
					if(HIWORD(wParam) == CBN_SELCHANGE)
					{
						selectionIndex = SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_GETCURSEL, 0, 0);
						for(int i = 0; i < 14; i++)
							if(i < selectionIndex + 3)
								ShowWindow(colors[i]->GetHandle(), true);
							else
								ShowWindow(colors[i]->GetHandle(), false);
						if(realtime)
						{
							SendMessage(hwnd, WM_PREVIEW_REFRESH, 0, 0);
						}

						return 0;
					}
				break;
				case IDC_EDIT_INDEX_INC:
				case IDC_EDIT_INDEX_VALUE:
					if(realtime)
					{
						SendMessage(hwnd, WM_PREVIEW_REFRESH, 0, 0);
					}
				break;
				case IDC_PALETTE_REALTIME:
					EnableWindow(GetDlgItem(hwnd, IDC_PALETTE_REFRESH), realtime);
					realtime = !realtime;
					SendMessage(hwnd, WM_PREVIEW_REFRESH, 0, 0);
					return 0;
				break;
				case IDC_PALETTE_REFRESH:
					SendMessage(hwnd, WM_PREVIEW_REFRESH, 0, 0);
					return 0;
				break;
				case IDC_PREVIEW_SMOOTH:
					smoothPreview = !smoothPreview;
					previewControl->SetSmooth(smoothPreview);
				break;
				case IDC_EDIT_PREVIEW_ITER:
					//previewControl->SetIterationCount(GetDlgItemInt(hwnd, IDC_EDIT_PREVIEW_ITER, 0, false));
				break;
				case IDC_BUTTON_PREVIEW_ITER_PLUS:
					previewControl->IncreaseIterationCount();
					SetDlgItemInt(hwnd, IDC_EDIT_PREVIEW_ITER, previewControl->GetIterationCount(), false);
				break;
				case IDC_BUTTON_PREVIEW_ITER_MINUS:
					previewControl->DecreaseIterationCount();
					SetDlgItemInt(hwnd, IDC_EDIT_PREVIEW_ITER, previewControl->GetIterationCount(), false);
				break;
            }
        break;
		case WM_PREVIEW_REFRESH:
			GetDlgItemText(hwnd, IDC_EDIT_INDEX_INC, tmp, 20);
			GetDlgItemText(hwnd, IDC_EDIT_INDEX_VALUE, tmp2, 20);
			newIndexInc = atof(tmp);
			newIndexValue = atof(tmp2);
			newColorCount = SendMessage(GetDlgItem(hwnd,IDC_COMBO_COLORCOUNT), CB_GETCURSEL, 0, 0) + 3;
			{
			unsigned char *newPalette = new unsigned char[newColorCount*3];
			for(int i = 0; i < newColorCount - 1; i++)
			{
				newPalette[3*i] = colors[i+1]->GetR();
				newPalette[3*i+1] = colors[i+1]->GetG();
				newPalette[3*i+2] = colors[i+1]->GetB();
			}
			newPalette[3*(newColorCount-1)] = colors[0]->GetR();
			newPalette[3*(newColorCount-1)+1] = colors[0]->GetG();
			newPalette[3*(newColorCount-1)+2] = colors[0]->GetB();

			previewControl->SetPalette(newPalette, newColorCount*3, newIndexValue, newIndexInc);
			delete [] newPalette;
			}
			InvalidateRect(previewControl->GetHandle(), NULL, false);
			UpdateWindow(previewControl->GetHandle());
		break;
		case WM_SET_HS:
			paletteSliderControl->SetHS((float)wParam/360.0f, (float)lParam/100.0f);
			for(int i = 0; i < 14; i++)
			{
				if(colors[i]->GetSelected())
				{
					colors[i]->SetHS((float)wParam/360.0f, (float)lParam/100.0f);
					InvalidateRect(colors[i]->GetHandle(), NULL, false);
					break;
				}
			}
			InvalidateRect(paletteSliderControl->GetHandle(), NULL, false);
			InvalidateRect(paletteControl->GetHandle(), NULL, false);
			if(realtime)
				SendMessage(hwnd, WM_PREVIEW_REFRESH, 0, 0);
			return 0;
		break;
		case WM_SET_V:
			paletteControl->SetV((float)wParam/100.0f);
			for(int i = 0; i < 14; i++)
			{
				if(colors[i]->GetSelected())
				{
					colors[i]->SetV((float)wParam/100.0f);
					InvalidateRect(colors[i]->GetHandle(), NULL, false);
					break;
				}
			}
			InvalidateRect(paletteSliderControl->GetHandle(), 0, false);
			InvalidateRect(paletteControl->GetHandle(), 0, false);
			if(realtime)
				SendMessage(hwnd, WM_PREVIEW_REFRESH, 0, 0);
			return 0;
		break;
		case WM_SET_RGB:
			paletteSliderControl->SetRGB((wParam & 0xFF0000) >> 16, (wParam & 0xFF00) >> 8, wParam & 0xFF);
			paletteControl->SetRGB((wParam & 0xFF0000) >> 16, (wParam & 0xFF00) >> 8, wParam & 0xFF);
			InvalidateRect(paletteSliderControl->GetHandle(), 0, false);
			InvalidateRect(paletteControl->GetHandle(), 0, false);
			return 0;
		break;
		case WM_SELECT_COLOR_SLOT:
			for(int i = 0; i < 14; i++)
			{
				colors[i]->SetSelected(false);
			}
			colors[wParam]->SetSelected(true);
			return 0;
		break;
		case WM_SET_RGB_HSV:
			changedByApp = 6;
			SetDlgItemInt(hwnd, IDC_EDIT_H, (lParam & 0xFFFF0000) >> 16, false);
			SetDlgItemInt(hwnd, IDC_EDIT_S, (lParam & 0xFF00) >> 8, false);
			SetDlgItemInt(hwnd, IDC_EDIT_V, (lParam & 0xFF), false);
			SetDlgItemInt(hwnd, IDC_EDIT_R, (wParam & 0xFF0000) >> 16, false);
			SetDlgItemInt(hwnd, IDC_EDIT_G, (wParam & 0xFF00) >> 8, false);
			SetDlgItemInt(hwnd, IDC_EDIT_B, (wParam & 0xFF), false);
			return 0;
		break;
		default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK DlgComputingProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);			
			
			// Set range
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETRANGE32, 0,200);
			// Set position to start
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETPOS, 0,0);
			progressBar = 0;
			animationObject->SetHandle(hwnd);
			animationObject->Reset();

			animationObject->Compute();
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDCANCEL:
					//TODO: abort
					//((CJuliaAnimObject*)animationObject)->AbortComputing();
					threadManager->Abort();
                    EndDialog(hwnd, IDCANCEL);
                break;
            }
        break;
		case WM_DESTROY:
		break;
		case WM_CALCUPDATE:
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETPOS, 20*progressBar++ /animationObject->GetNumFrames(),0);
		break;
		case WM_CALCDONE:
			animationObject->FrameFinished();
			if(animationObject->IsReady())
			{
				SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETPOS, 200,0);
				EndDialog(hwnd, IDOK);
			}
		break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK DlgAnimPlayerProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);			
			
			// Nastavme rozsah
			SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETRANGE,TRUE, MAKELONG(0,animationObject->GetNumFrames()-1));
			// Nastavme poziciu na zaciatok
			SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETPOS, TRUE, 0);
			animCurrentFrame = 0;

			SendDlgItemMessage(hwnd, IDC_BUTTON_PLAY, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP,(LPARAM)LoadBitmap(instance, MAKEINTRESOURCE(IDR_PLAYICON)));
			SendDlgItemMessage(hwnd, IDC_BUTTON_PREVFRAME, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP,(LPARAM)LoadBitmap(instance, MAKEINTRESOURCE(IDR_PREVICON)));
			SendDlgItemMessage(hwnd, IDC_BUTTON_NEXTFRAME, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP,(LPARAM)LoadBitmap(instance, MAKEINTRESOURCE(IDR_NEXTICON)));
			SendDlgItemMessage(hwnd, IDC_BUTTON_STOP, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP,(LPARAM)LoadBitmap(instance, MAKEINTRESOURCE(IDR_STOPICON)));

			fractalControlAnim = new CControlAnim(hwnd, video_quality);
			fractalControlAnim->SetCurrentFractalObject(animationObject->GetFrame(0));
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
            case IDCANCEL:
				EndDialog(hwnd, IDCANCEL);
            break;
			case IDC_BUTTON_PREVFRAME:
				if(animCurrentFrame > 0)
				{
					fractalControlAnim->SetCurrentFractalObject(animationObject->GetFrame(--animCurrentFrame));
					SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETPOS, TRUE, animCurrentFrame);
				}
			break;
			case IDC_BUTTON_NEXTFRAME:
				if(animCurrentFrame < animationObject->GetNumFrames() - 1)
				{
					fractalControlAnim->SetCurrentFractalObject(animationObject->GetFrame(++animCurrentFrame));
					SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETPOS, TRUE, animCurrentFrame);
				}
			break;
			case IDC_BUTTON_STOP:
				animPlaying = false;
				SendDlgItemMessage(hwnd, IDC_BUTTON_PLAY, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP,(LPARAM)LoadBitmap(instance, MAKEINTRESOURCE(IDR_PLAYICON)));
				animCurrentFrame = 0;
				fractalControlAnim->SetCurrentFractalObject(animationObject->GetFrame(animCurrentFrame));
				SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETPOS, TRUE, animCurrentFrame);
			break;
			case IDC_BUTTON_PLAY:
				if(animPlaying)
				{
					animPlaying = false;
					SendDlgItemMessage(hwnd, IDC_BUTTON_PLAY, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP,(LPARAM)LoadBitmap(instance, MAKEINTRESOURCE(IDR_PLAYICON)));
				}
				else
				{
					animPlaying = true;
					if(animCurrentFrame == animationObject->GetNumFrames() - 1)
						animCurrentFrame = 0;
					SendDlgItemMessage(hwnd, IDC_BUTTON_PLAY, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP,(LPARAM)LoadBitmap(instance, MAKEINTRESOURCE(IDR_PAUSEICON)));
					PostMessage(hwnd, WM_NEXTFRAME, NULL, NULL);
				}
			break;
			}
        break;
		case WM_HSCROLL:
			if(LOWORD(wParam) == SB_THUMBTRACK || LOWORD(wParam) == SB_ENDSCROLL)
			{
				animCurrentFrame = SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_GETPOS, 0, 0);
				fractalControlAnim->SetCurrentFractalObject(animationObject->GetFrame(animCurrentFrame));
			}
			return 0;
		break;
		case WM_DESTROY:
		break;
		case WM_NEXTFRAME:
			if(animPlaying && animCurrentFrame < animationObject->GetNumFrames()-1)
			{
				PlayFrame(hwnd);
				fractalControlAnim->SetCurrentFractalObject(animationObject->GetFrame(++animCurrentFrame));
				SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETPOS, TRUE, animCurrentFrame);
			}
			if(animCurrentFrame == animationObject->GetNumFrames() - 1)
			{
				animPlaying = false;
				SendDlgItemMessage(hwnd, IDC_BUTTON_PLAY, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP,(LPARAM)LoadBitmap(instance, MAKEINTRESOURCE(IDR_PLAYICON)));
			}
		break;
        default:
            return FALSE;
    }
    return TRUE;
}

void LaunchAnimPlayer(HWND hwnd)
{
	video_quality = SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0);
	switch(video_quality)
	{
		case 0:
			DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_ANIMPLAYER_LOW), hwnd, DlgAnimPlayerProc);
		break;
		case 1:
			DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_ANIMPLAYER_MED), hwnd, DlgAnimPlayerProc);
		break;
		case 2:
			DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_ANIMPLAYER_HIGH), hwnd, DlgAnimPlayerProc);
		break;
	}
}
BOOL CALLBACK DlgJuliaAnimProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	char *fileName;
	int ret;
	bool confirm = true;

    switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);			
			
			rightWindow = new CControlJulia(hwnd, PREVIEW_QUALITY_ANIM);
			leftWindowNURBS = new CControlMandNURBS(hwnd, rightWindow->GetHandle(), rightWindow->GetFractalObject(), juliaNURBSObject, defaultMandBig);
				
			SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETRANGE,TRUE, MAKELONG(0,24));
			SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETPOS, TRUE, 0);

			strX.str("");
			strY.str("");
			strFPS.str("");
			strStepFrames.str("");
			strIter.str("");
			
			strX << std::setprecision(sig_digits((float)leftWindowNURBS->GetFrameSeedX())) << leftWindowNURBS->GetFrameSeedX();
			strY << std::setprecision(sig_digits((float)leftWindowNURBS->GetFrameSeedY())) << leftWindowNURBS->GetFrameSeedY();
				
			if(animationObject != NULL && animationObject->m_animObjectType == JULIA_ANIM_OBJECT)
			{
				strFPS << std::setprecision(sig_digits(animationObject->GetFPS())) << animationObject->GetFPS();
				strStepFrames << std::setprecision(sig_digits(((CJuliaAnimObject*)animationObject)->GetFrameStepCount())) << ((CJuliaAnimObject*)animationObject)->GetFrameStepCount();
				strIter << std::setprecision(sig_digits(((CJuliaAnimObject*)animationObject)->GetIterationCount())) << ((CJuliaAnimObject*)animationObject)->GetIterationCount();
			}
			else
			{
				strFPS << 24;
				strStepFrames << 24;
				strIter << 128;
			}
			
			SetDlgItemText(hwnd, IDC_EDIT_X, strX.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_Y, strY.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_FPS, strFPS.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_FRAMESTEPS, strStepFrames.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_ITERATIONS, strIter.str().c_str());

			EnableWindow(GetDlgItem(hwnd, IDC_BUTTON_SAVEFILE), FALSE);

			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("320x256"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("640x512"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("800x640"));
			
			SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_SETCURSEL, 1, 0);

			if(animationReady && animationObject->m_animObjectType == MOVE_ANIM_OBJECT)
			{
				SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Animation Ready");
				SetDlgItemText(hwnd, IDOK, "Run");
			}

			quality = SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0);

		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
	            case IDOK:
					if(!ValidateDialog(CHECK_ANIM_JULIA, hwnd))
						return FALSE;
					
					if(animationObject != NULL && animationObject->IsReady() && animationReady)
					{
						LaunchAnimPlayer(hwnd);
					}
					else{
						leftWindowNURBS->SetStepFrames(GetDlgItemInt(hwnd, IDC_EDIT_FRAMESTEPS, false, false));

						if(animationObject && animationObject->m_animObjectType == JULIA_ANIM_OBJECT)
							((CJuliaAnimObject*)animationObject)->Clear(SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0),
																		GetDlgItemInt(hwnd, IDC_EDIT_ITERATIONS, false, false));
						else
						{
							if(animationObject != NULL && animationObject->m_animObjectType != JULIA_ANIM_OBJECT && animationObject->IsReady())
								confirm = IDOK == MessageBox(hwnd, "There is already computed animation in memory, continuing will delete this animation. Do you want to continue?", "Animation already exists", MB_ICONWARNING | MB_OKCANCEL);
							if(confirm)
							{
								if(animationObject)
									delete animationObject;
							
								animationObject = new CJuliaAnimObject(leftWindowNURBS->GetNURBSObject(), 
																		GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false),
																		GetDlgItemInt(hwnd, IDC_EDIT_ITERATIONS, false, false),
																		SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0),
																		hwnd);
							}
						}
						if(confirm)
						{
							ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_COMPUTING), hwnd, DlgComputingProc);
							if(ret == IDOK)
							{
								EnableWindow(GetDlgItem(hwnd, IDC_BUTTON_SAVEFILE), TRUE);
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
					}
					
                break;
                case IDCANCEL:
					EndDialog(hwnd, IDCANCEL);
                break;
				case IDC_BUTTON_SAVEFILE:
					fileName = SaveAviFile(hwnd);
					if(fileName != NULL)
						animationObject->CreateAVI(fileName, GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false), hwnd);
					delete [] fileName;
				break;
				case IDC_EDIT_FRAMESTEPS:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						leftWindowNURBS->SetStepFrames(GetDlgItemInt(hwnd, IDC_EDIT_FRAMESTEPS, false, false));
						SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETRANGE,TRUE, MAKELONG(0,leftWindowNURBS->GetRange()));
						if(CheckAnimObjectSettings(CHECK_ANIM_JULIA, hwnd))
						{
							if(animationObject != NULL && animationObject->IsReady())
							{
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
						else
						{
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;
						}
					}
				break;
				case IDC_EDIT_ITERATIONS:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(CheckAnimObjectSettings(CHECK_ANIM_JULIA, hwnd))
						{
							if(animationObject != NULL && animationObject->IsReady())
							{
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
						else
						{
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;
						}
					}
				case IDC_EDIT_FPS:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(animationObject != NULL && animationObject->GetFPS() == GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false))
							animationObject->SetFPS(GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false));
					}
				break;
				case IDC_COMBO1:
					if(HIWORD(wParam) == CBN_SELCHANGE)
					{
						quality = SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0);
						if(CheckAnimObjectSettings(CHECK_ANIM_JULIA, hwnd))
						{
							if(animationObject != NULL && animationObject->IsReady())
							{
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
						else
						{
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;
						}
					}
				break;
            }
        break;
		case WM_DESTROY:
			delete rightWindow;
			juliaNURBSObject = leftWindowNURBS->GetNURBSObject();
			delete leftWindowNURBS;
		break;
		case WM_HSCROLL:
			leftWindowNURBS->SetFrame(SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_GETPOS, 0, 0));
			
			strX.str("");
			strY.str("");
			strX << std::setprecision(sig_digits((float)leftWindowNURBS->GetFrameSeedX())) << leftWindowNURBS->GetFrameSeedX();
			strY << std::setprecision(sig_digits((float)leftWindowNURBS->GetFrameSeedY())) << leftWindowNURBS->GetFrameSeedY();

			SetDlgItemText(hwnd, IDC_EDIT_X, strX.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_Y, strY.str().c_str());
		break;
		case WM_UPDATERANGE:
			SendDlgItemMessage(hwnd, IDC_TRACKBAR, TBM_SETRANGE,TRUE, MAKELONG(0,wParam));
		break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK DlgSaveFileProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);			
			
			// Nastavme rozsah
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETRANGE32, 0,200);
			// Nastavme poziciu na zaciatok
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETPOS, 0,0);
			progressBar = 0;
			renderedImage->SetHWND(hwnd);
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDCANCEL:
					renderedImage->Abort();
                    EndDialog(hwnd, IDCANCEL);
                break;
            }
        break;
		case WM_CALCUPDATE:
			progressBar++;
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETPOS, progressBar*20,0);
		break;
		case WM_CALCDONE:
			timer->Stop();
			EndDialog(hwnd, IDOK);
		break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK JuliaDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	long double x;
	long double y;
	char tmp[20];
	int previewQuality = PREVIEW_QUALITY_MEDIUM;
    switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);
			if(fractalControl->GetFractalType() == FRACTAL_TYPE_JULIA)
			{
				rightWindow = new CControlJulia(hwnd, PREVIEW_QUALITY_MEDIUM, ((CJulia*)fractalControl->GetFractalObject())->GetSeed().r, ((CJulia*)fractalControl->GetFractalObject())->GetSeed().i);
				leftWindow = new CControlMand(hwnd, rightWindow->GetHandle(), rightWindow->GetFractalObject(), defaultMandSmall);
				strX.str("");
				strY.str("");
				strX << std::setprecision(sig_digits(((CJulia*)fractalControl->GetFractalObject())->GetSeed().r)) << ((CJulia*)fractalControl->GetFractalObject())->GetSeed().r;
				strY << std::setprecision(sig_digits(((CJulia*)fractalControl->GetFractalObject())->GetSeed().i)) << ((CJulia*)fractalControl->GetFractalObject())->GetSeed().i;
				SetDlgItemText(hwnd, IDC_EDIT_X, strX.str().c_str());
				SetDlgItemText(hwnd, IDC_EDIT_Y, strY.str().c_str());
			}
			else
			{
				rightWindow = new CControlJulia(hwnd, PREVIEW_QUALITY_MEDIUM);
				leftWindow = new CControlMand(hwnd, rightWindow->GetHandle(), rightWindow->GetFractalObject(), defaultMandSmall);
				SetDlgItemText(hwnd, IDC_EDIT_X, "-0.4");
				SetDlgItemText(hwnd, IDC_EDIT_Y, "0.6");
			}
			
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("Low"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("Medium"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("High"));

			SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_SETCURSEL, 1, 0);
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDOK:
					fractalControl->SetCurrentJulia(leftWindow->GetPointX(), leftWindow->GetPointY());
					EndDialog(hwnd, IDOK);
                break;
                case IDCANCEL:
                    EndDialog(hwnd, IDCANCEL);
                break;
				case IDC_EDIT_X:
				case IDC_EDIT_Y:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(changedByApp > 0)
						{
							changedByApp--;
							return 1;
						}

						GetDlgItemText(hwnd, IDC_EDIT_X, tmp, 20);
						x = atof(tmp);
						GetDlgItemText(hwnd, IDC_EDIT_Y, tmp, 20);
						y = atof(tmp);
						leftWindow->SetPointPossition(x,y);
					}
				break;
				case IDC_COMBO1:
					if(HIWORD(wParam) == CBN_SELCHANGE)
					{
						rightWindow->SetQuality(SendMessage((HWND)lParam, CB_GETCURSEL, 0, 0));
						UpdateWindow(hwnd);
					}
				break;
            }
        break;
		case WM_UPDATEPOSITION:
			changedByApp = 2;

			//wParam is unsigned int so we have to do some woodoo tricks to get negative numbers
			x = (float)wParam/100000.0f;
			if(x > 2)
			{
				x = 0xffffffff - wParam;
				x = (-x)/100000.0f;
			}
			//woodoo tricks done :) lParam is long so we don't have to repeat these steps for it

			strX.str("");
			strY.str("");
			strX << x;
			strY << (float)lParam/100000.0f;

			SetDlgItemText(hwnd, IDC_EDIT_X, strX.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_Y, strY.str().c_str());
		break;
		case WM_NCDESTROY:
			delete leftWindow;
			delete rightWindow;
		break;
		case WM_CALCDONE:
			threadsFinished++;
			if(threadsFinished == threadManager->GetThreadCount())
			{
				InvalidateRect(rightWindow->GetHandle(), NULL, false);
				UpdateWindow(rightWindow->GetHandle());
				threadsFinished = 0;
			}
		break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK DlgImageProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	char tmp[20];

	CFractal *fractal;

    switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);

			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("800x600"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("1024x768"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("1280x1024"));
			SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_SETCURSEL, 1, 0);
			
			fractal = fractalControl->GetFractalObject();

			x = (fractal->m_xMax + fractal->m_xMin)/2;
			strX.str("");
			strX << std::setprecision(sig_digits(x)) << x;
			y = (fractal->m_yMax + fractal->m_yMin)/2;
			strY.str("");
			strY << std::setprecision(sig_digits(y)) << y;

			zoom = fractal->m_zoomDepth;
			strZoom.str("");
			strZoom << std::setprecision(sig_digits(zoom)) << zoom;

			iterations = fractal->m_iterationCount;
			strIter.str("");
			strIter << std::setprecision(sig_digits(iterations)) << iterations;

			mexp = fractal->m_exp;
			strExp.str("");
			strExp << std::setprecision(sig_digits(mexp)) << mexp;
			
			SetDlgItemText(hwnd, IDC_EDIT_X, strX.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_Y, strY.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_ZOOM, strZoom.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_ITERATIONS, strIter.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_EXP2, strExp.str().c_str());

			renderedImage = fractal;
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
				case IDC_COMBO1:									// combobox - resolution
				if(HIWORD(wParam) == CBN_SELCHANGE){
					resolution = (char)SendMessage((HWND)lParam, CB_GETCURSEL, 0, 0);
				}
				break;
                case IDOK:
					iterations = GetDlgItemInt(hwnd, IDC_EDIT_ITERATIONS, false, false);
					GetDlgItemText(hwnd, IDC_EDIT_ZOOM, tmp, 20);
					zoom = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_X, tmp, 20);
					x = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_Y, tmp, 20);
					y = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_EXP2, tmp, 20);
					mexp = atof(tmp);
					if(customRes){
						custWidth = GetDlgItemInt(hwnd, IDC_EDIT_CWIDTH, false, false);
						if(custWidth%2 == 1)
							custWidth++;
						custHeight = GetDlgItemInt(hwnd, IDC_EDIT_CHEIGHT, false, false);
					}
					EndDialog(hwnd, IDOK);
                break;
                case IDCANCEL:
                    EndDialog(hwnd, IDCANCEL);
                break;
				case IDC_CHECK1:
					if(SendDlgItemMessage(hwnd,IDC_CHECK1, BM_GETCHECK,0,0)){
						EnableWindow(GetDlgItem(hwnd,IDC_COMBO1), false);
						EnableWindow(GetDlgItem(hwnd,IDC_EDIT_CWIDTH), true);
						EnableWindow(GetDlgItem(hwnd,IDC_EDIT_CHEIGHT), true);
						customRes = true;
					}
					else{
						EnableWindow(GetDlgItem(hwnd,IDC_COMBO1), true);
						EnableWindow(GetDlgItem(hwnd,IDC_EDIT_CWIDTH), false);
						EnableWindow(GetDlgItem(hwnd,IDC_EDIT_CHEIGHT), false);
						customRes = false;
					}
				break;
            }
        break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK DlgSettingsProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	char tmp[20];

	CFractal *fractal;
	long double t;

    switch(Message)
    {
	    case WM_INITDIALOG:
			CenterDialog(hwnd);

			fractal = fractalControl->GetFractalObject();

			strX.str("");
			strY.str("");
			strZoom.str("");
			strIter.str("");
			strExp.str("");
			
			t = (fractal->m_xMax + fractal->m_xMin)/(double)2;
			strX << std::setprecision(sig_digits(t)) << t;
			
			t = (fractal->m_yMax + fractal->m_yMin)/(double)2;
			strY << std::setprecision(sig_digits(t)) << t;
			strZoom << std::setprecision(sig_digits(fractal->m_zoomDepth)) << fractal->m_zoomDepth;
			strIter << /*std::setprecision(sig_digits(fractal->m_iterationCount)) <<*/ fractal->m_iterationCount;
			strExp << std::setprecision(sig_digits(fractal->m_exp)) << fractal->m_exp;
	
			SetDlgItemText(hwnd, IDC_EDIT_X, strX.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_Y, strY.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_ZOOM, strZoom.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_ITERATIONS, strIter.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_EXP, strExp.str().c_str());
			
			renderedImage = fractal;
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDOK:
					iterations = GetDlgItemInt(hwnd, IDC_EDIT_ITERATIONS, false, false);
					GetDlgItemText(hwnd, IDC_EDIT_ZOOM, tmp, 20);
					zoom = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_X, tmp, 20);
					x = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_Y, tmp, 20);
					y = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_EXP, tmp, 20);
					mexp = atof(tmp);
					EndDialog(hwnd, IDOK);
                break;
                case IDCANCEL:
                    EndDialog(hwnd, IDCANCEL);
                break;
            }
        break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK DlgSettingsJuliaProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	char tmp[20];
	CFractal *fractal;
	long double t;

	switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);

			fractal = fractalControl->GetFractalObject();

			strX.str("");
			strY.str("");
			strSeedX.str("");
			strSeedY.str("");
			strZoom.str("");
			strIter.str("");
			strExp.str("");
			
			t = (fractal->m_xMax + fractal->m_xMin)/2;
			strX << std::setprecision(sig_digits(t)) << t;
			t = (fractal->m_yMax + fractal->m_yMin)/2;
			strY << std::setprecision(sig_digits(t)) << t;
			strZoom << std::setprecision(sig_digits(fractal->m_zoomDepth)) << fractal->m_zoomDepth;
			strIter << std::setprecision(sig_digits(fractal->m_iterationCount)) << fractal->m_iterationCount;
			strExp << std::setprecision(sig_digits(fractal->m_exp)) << fractal->m_exp;
			strSeedX << std::setprecision(sig_digits(((CJulia*)fractal)->GetSeed().r)) << ((CJulia*)fractal)->GetSeed().r;
			strSeedY << std::setprecision(sig_digits(((CJulia*)fractal)->GetSeed().i)) << ((CJulia*)fractal)->GetSeed().i;

			SetDlgItemText(hwnd, IDC_EDIT_X, strX.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_Y, strY.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_ZOOM, strZoom.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_ITERATIONS, strIter.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_EXP, strExp.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_SEEDX, strSeedX.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_SEEDY, strSeedY.str().c_str());
			
			renderedImage = fractal;
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDOK:
					iterations = GetDlgItemInt(hwnd, IDC_EDIT_ITERATIONS, false, false);
					GetDlgItemText(hwnd, IDC_EDIT_ZOOM, tmp, 20);
					zoom = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_X, tmp, 20);
					x = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_Y, tmp, 20);
					y = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_EXP, tmp, 20);
					mexp = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_SEEDX, tmp, 20);
					seedX = atof(tmp);
					GetDlgItemText(hwnd, IDC_EDIT_SEEDY, tmp, 20);
					seedY = atof(tmp);
					EndDialog(hwnd, IDOK);
                break;
                case IDCANCEL:
                    EndDialog(hwnd, IDCANCEL);
                break;
            }
        break;
	    default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK DlgExpAnimationProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	char tmp[20];
	char tmp2[20];
	char *fileName;
	int ret;
	bool confirm = true;

    switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);

			EnableWindow(GetDlgItem(hwnd, IDC_BUTTON_SAVEFILE), FALSE);
			
			// Set range
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETRANGE32, 0,200);
			// Set position to start
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETPOS, 0,0);
			progressBar = 0;

			strNumFrames.str("");
			strFPS.str("");
			strStartExp.str("");
			strEndExp.str("");
			
			if(animationObject != NULL)
			{
				strNumFrames << std::setprecision(sig_digits(animationObject->GetNumFrames())) << animationObject->GetNumFrames();
				strFPS << std::setprecision(sig_digits(animationObject->GetFPS())) << animationObject->GetFPS();

				if(animationObject->m_animObjectType == EXP_ANIM_OBJECT)
				{
					strStartExp << std::setprecision(sig_digits(((CExpAnimObject*)animationObject)->GetStartExp())) << ((CExpAnimObject*)animationObject)->GetStartExp();
					strEndExp << std::setprecision(sig_digits(((CExpAnimObject*)animationObject)->GetEndExp())) << ((CExpAnimObject*)animationObject)->GetEndExp();
				}
				else
				{
					strStartExp << "2.0";
					strEndExp << "3.0";
				}
			}
			else
			{
				strNumFrames << 40;
				strFPS << 24;
				strStartExp << "2.0";
				strEndExp << "3.0";
			}

			SetDlgItemText(hwnd, IDC_EDIT_NUMFRAMES, strNumFrames.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_FPS, strFPS.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_STARTEXP, strStartExp.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_ENDEXP, strEndExp.str().c_str());

			if(animationReady && animationObject->m_animObjectType == EXP_ANIM_OBJECT)
			{
				SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Animation Ready");
				SetDlgItemText(hwnd, IDOK, "Run");
			}

			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("320x256"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("640x512"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("800x640"));
			
			SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_SETCURSEL, 1, 0);
			
			quality = SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0);
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
	            case IDOK:
					if(!ValidateDialog(CHECK_ANIM_EXP, hwnd))
						return FALSE;
					
					if(animationObject != NULL && animationObject->IsReady() && animationReady && animationObject->m_animObjectType == EXP_ANIM_OBJECT)
					{
						LaunchAnimPlayer(hwnd);
					}
					else
					{
						if(animationObject != NULL && animationObject->m_animObjectType == EXP_ANIM_OBJECT)
						{
							GetDlgItemText(hwnd, IDC_EDIT_STARTEXP, tmp, 20);
							GetDlgItemText(hwnd, IDC_EDIT_ENDEXP, tmp2, 20);
							((CExpAnimObject*)animationObject)->Clear(	SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0), 
																		GetDlgItemInt(hwnd, IDC_EDIT_NUMFRAMES, false, false),
																		atof(tmp),
																		atof(tmp2),
																		fractalControl->GetFractalObject());
						}
						else
						{
							if(animationObject != NULL && animationObject->m_animObjectType != EXP_ANIM_OBJECT && animationObject->IsReady())
								confirm = IDOK == MessageBox(hwnd, "There is already computed animation in memory, continuing will delete this animation. Do you want to continue?", "Animation already exists", MB_ICONWARNING | MB_OKCANCEL);
							if(confirm)
							{
								GetDlgItemText(hwnd, IDC_EDIT_STARTEXP, tmp, 20);
								GetDlgItemText(hwnd, IDC_EDIT_ENDEXP, tmp2, 20);
								delete animationObject;
								animationObject = new CExpAnimObject(fractalControl->GetFractalType(), 
																	 GetDlgItemInt(hwnd, IDC_EDIT_NUMFRAMES, false, false),
																	 GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false),
																	 atof(tmp),
																	 atof(tmp2),
																	 hwnd, 
																	 SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0),
																	 fractalControl->GetFractalObject()); 
							}
						}
						if(confirm)
						{
							ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_COMPUTING), hwnd, DlgComputingProc);
							if(ret == IDOK)
							{
								EnableWindow(GetDlgItem(hwnd, IDC_BUTTON_SAVEFILE), TRUE);
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
					}
					
                break;
                case IDCANCEL:
					EndDialog(hwnd, IDCANCEL);
	            break;
				case IDC_BUTTON_SAVEFILE:
					fileName = SaveAviFile(hwnd);
					if(fileName != NULL)
						animationObject->CreateAVI(fileName, 24, hwnd);
					delete [] fileName;
				break;
				case IDC_EDIT_NUMFRAMES:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(CheckAnimObjectSettings(CHECK_ANIM_EXP, hwnd))
						{
							if(animationObject != NULL && animationObject->IsReady())
							{
								SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Animation Ready");
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
						else
						{
							SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Press Compute button to start calculation");
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;	
						}
					}
				break;
				case IDC_EDIT_FPS:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(animationObject != NULL && animationObject->GetFPS() != GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false))
							animationObject->SetFPS(GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false));
					}
				break;
				case IDC_EDIT_STARTEXP:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(CheckAnimObjectSettings(CHECK_ANIM_EXP, hwnd))
						{
							if(animationObject != NULL && animationObject->IsReady())
							{
								SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Animation Ready");
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
						else
						{
							SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Press Compute button to start calculation");
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;
						}
					}
				break;
				case IDC_EDIT_ENDEXP:
					if(HIWORD(wParam) == EN_CHANGE){
						if(CheckAnimObjectSettings(CHECK_ANIM_EXP, hwnd))
						{
							if(animationObject != NULL && animationObject->IsReady())
							{
								SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Animation Ready");
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
						else
						{
							SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Press Compute button to start calculation");
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;
						}
					}
				break;
				case IDC_COMBO1:
					if(HIWORD(wParam) == CBN_SELCHANGE)
					{
						quality = SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0);
						if(CheckAnimObjectSettings(CHECK_ANIM_EXP, hwnd))
						{
							if(animationObject != NULL && animationObject->IsReady())
							{
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
						else
						{
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;
						}
					}
				break;
            }
        break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK DlgMoveAnimationProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	char *fileName;
	int ret;
	bool confirm = true;

    switch(Message)
    {
        case WM_INITDIALOG:
			CenterDialog(hwnd);

			// Set range
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETRANGE32, 0,200);
			// Set position to start
			SendDlgItemMessage(hwnd, IDC_PROGRESS1, PBM_SETPOS, 0,0);

			strStepFrameCount.str("");
			strFPSmove.str("");
			strStepCount.str("");
			
			if(animationObject != NULL)
			{
				strFPSmove << std::setprecision(sig_digits(animationObject->GetFPS())) << animationObject->GetFPS();
				strStepCount << std::setprecision(sig_digits(path->GetStepCount())) << path->GetStepCount();
				if(animationObject->m_animObjectType == MOVE_ANIM_OBJECT)
					strStepFrameCount << std::setprecision(sig_digits(((CMoveAnimObject*)animationObject)->GetStepFrameCount())) << ((CMoveAnimObject*)animationObject)->GetStepFrameCount();
				else
					strStepFrameCount << "24";
			}
			else
			{
				strFPSmove << 24;
				strStepCount << std::setprecision(sig_digits(path->GetStepCount())) << path->GetStepCount();
				strStepFrameCount << "24";
			}
			
			SetDlgItemText(hwnd, IDC_EDIT_STEPCOUNT, strStepCount.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_STEPFRAMES, strStepFrameCount.str().c_str());
			SetDlgItemText(hwnd, IDC_EDIT_FPS, strFPSmove.str().c_str());
			
			if(animationReady && animationObject->m_animObjectType == MOVE_ANIM_OBJECT)
			{
				SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Animation Ready");
				SetDlgItemText(hwnd, IDOK, "Run");
			}
			
			EnableWindow(GetDlgItem(hwnd, IDC_EDIT_STEPCOUNT), FALSE);
			EnableWindow(GetDlgItem(hwnd, IDC_BUTTON_SAVEFILE), FALSE);

			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("320x256"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("640x512"));
			SendDlgItemMessage(hwnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)("800x640"));
			
			SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_SETCURSEL, 1, 0);

			quality = SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0);
		return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
	            case IDOK:
					if(!ValidateDialog(CHECK_ANIM_MOVE, hwnd))
						return FALSE;
					
					if(animationObject != NULL && animationObject->IsReady() && animationReady)
					{
						LaunchAnimPlayer(hwnd);
					}
					else
					{
						if(animationObject != NULL && animationObject->m_animObjectType == MOVE_ANIM_OBJECT)
						{
							((CMoveAnimObject*)animationObject)->Clear( SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0),
																		GetDlgItemInt(hwnd, IDC_EDIT_STEPFRAMES, false, false),
																		fractalControl->GetFractalObject());
						}
						else
						{
							if(animationObject != NULL && animationObject->m_animObjectType != MOVE_ANIM_OBJECT && animationObject->IsReady())
								confirm = IDOK == MessageBox(hwnd, "There is already computed animation in memory, continuing will delete this animation. Do you want to continue?", "Animation already exists", MB_ICONWARNING | MB_OKCANCEL);
							if(confirm)
							{
								delete animationObject;
								animationObject= new CMoveAnimObject(fractalControl->GetFractalType(), path, 
																	 GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false), 
																	 GetDlgItemInt(hwnd, IDC_EDIT_STEPFRAMES, false, false), 
																	 GetDlgItemInt(hwnd, IDC_EDIT_STEPCOUNT, false, false), 
																	 hwnd, 
																	 SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0),
																	 fractalControl->GetFractalObject());
							}
						}
						if(confirm)
						{
							ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_COMPUTING), hwnd, DlgComputingProc);
							if(ret == IDOK)
							{
								EnableWindow(GetDlgItem(hwnd, IDC_BUTTON_SAVEFILE), TRUE);
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
					}
					
                break;
                case IDCANCEL:
					EndDialog(hwnd, IDCANCEL);
                break;
				case IDC_BUTTON_SAVEFILE:
					fileName = SaveAviFile(hwnd);
					animationObject->CreateAVI(fileName, 24, hwnd);
					delete [] fileName;
				break;
				case IDC_EDIT_STEPFRAMES:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(CheckAnimObjectSettings(CHECK_ANIM_MOVE, hwnd) && animationObject->IsReady())
						{
							SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Animation Ready");
							SetDlgItemText(hwnd, IDOK, "Run");
							animationReady = true;
						}
						else
						{
							SetDlgItemText(hwnd, IDC_ANIMATION_PROGRESSTEXT, "Press Compute button to start calculation");
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;
						}
					}
				break;
				case IDC_EDIT_FPS:
					if(HIWORD(wParam) == EN_CHANGE)
					{
						if(animationObject != NULL && animationObject->GetFPS() != GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false))
							animationObject->SetFPS(GetDlgItemInt(hwnd, IDC_EDIT_FPS, false, false));
					}
				break;
				case IDC_COMBO1:
					if(HIWORD(wParam) == CBN_SELCHANGE)
					{
						quality = SendMessage(GetDlgItem(hwnd,IDC_COMBO1), CB_GETCURSEL, 0, 0);
						if(CheckAnimObjectSettings(CHECK_ANIM_MOVE, hwnd))
						{
							if(animationObject != NULL && animationObject->IsReady())
							{
								SetDlgItemText(hwnd, IDOK, "Run");
								animationReady = true;
							}
						}
						else
						{
							SetDlgItemText(hwnd, IDOK, "Compute");
							animationReady = false;
						}
					}
				break;
            }
        break;
        default:
            return FALSE;
    }
    return TRUE;
}

// the Window Procedure
LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	char *fileName;
	int ret;
	CFractal *fractal;

	std::stringstream ist;

    switch(msg)
    {
		case WM_CREATE:
			CenterDialog(hwnd);
			SetMenu(hwnd, menuMand);
			defaultMandBig = new CMandelbrot(640,512, NULL);
			defaultMandSmall = new CMandelbrot(320, 256, NULL);
			defaultMandBig->SetHWND(hwnd);
			initialCalc = true;
			timer->Start();
			defaultMandBig->Compute();
		break;
		case WM_KEYDOWN:
			fractalControl->OnKeyPress(wParam);
		break;
  		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case ID_FILE_EXIT:
					PostMessage(hwnd, WM_CLOSE, 0, 0);
				break;
				case ID_RENDER_IMAGE:
					ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_IMAGE), hwnd, DlgImageProc);
					if(ret == IDOK)
					{
						if(customRes)
						{
							switch(fractalControl->GetFractalType())
							{
							case FRACTAL_TYPE_MAND:
								renderedImage = new CMandelbrot(custWidth, custHeight, hwnd, (CMandelbrot*)fractalControl->GetFractalObject());
							break;
							case FRACTAL_TYPE_JULIA:
								renderedImage = new CJulia(custWidth, custHeight, hwnd, (CJulia*)fractalControl->GetFractalObject());
							break;
							}
						}
						else
							switch(resolution){
								case 0:
									switch(fractalControl->GetFractalType())
									{
									case FRACTAL_TYPE_MAND:
										renderedImage = new CMandelbrot(800, 600, hwnd, (CMandelbrot*)fractalControl->GetFractalObject());
									break;
									case FRACTAL_TYPE_JULIA:
										renderedImage = new CJulia(800, 600, hwnd, (CJulia*)fractalControl->GetFractalObject());
									break;
									}
								break;
								case 1: 
									switch(fractalControl->GetFractalType())
									{
									case FRACTAL_TYPE_MAND:
										renderedImage = new CMandelbrot(1024, 768, hwnd, (CMandelbrot*)fractalControl->GetFractalObject());
									break;
									case FRACTAL_TYPE_JULIA:
										renderedImage = new CJulia(1024, 768, hwnd, (CJulia*)fractalControl->GetFractalObject());
									break;
									}
								break;
								case 2:
									switch(fractalControl->GetFractalType())
									{
									case FRACTAL_TYPE_MAND:
										renderedImage = new CMandelbrot(1280, 1024, hwnd, (CMandelbrot*)fractalControl->GetFractalObject());
									break;
									case FRACTAL_TYPE_JULIA:
										renderedImage = new CJulia(1280, 1024, hwnd, (CJulia*)fractalControl->GetFractalObject());
									break;
									}
								break;
							}
						fileName = SaveBmpFile(hwnd);
						if(fileName != NULL)
						{
							renderedImage->SetFractal(x,y,iterations, zoom, mexp);
							threadManager->ClearTasks();
							threadManager->AddTask(renderedImage, 1);
							timer->Start();
							threadManager->RunTasks();

							ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_SAVEFILE), hwnd, DlgSaveFileProc);
							ist << "Done in " << timer->GetTime()/1000.0f << " seconds";
							SetWindowText(hwndStatusBar, ist.str().c_str());
							if(ret == IDOK)
								fractalControl->SaveToBmp(fileName, renderedImage->GetImage(),renderedImage->GetSizeX(), renderedImage->GetSizeY());
						}
						delete [] fileName;
					}
		        break;
				case ID_RENDER_EXPANIMATION:
					DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_ANIMATION), hwnd, DlgExpAnimationProc);
		        break;
				case ID_RENDER_ZOOMANIMATION_START:
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_END, MF_ENABLED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_START, MF_DISABLED| MF_GRAYED);
					
					if(path == NULL)
					{
						path = new CAnimationPath();
						path->SetRecordFullPath(recordFullPath);
					}
					fractalControl->SetPathObject(path);
			
					path->m_active = true;
					path->Clear();
					fractal = fractalControl->GetFractalObject();
					path->Add(fractal->m_zoomDepth, fractal->m_xMin, fractal->m_xMax, fractal->m_yMin,
							  fractal->m_yMax, fractal->m_exp, fractal->m_iterationCount);

					if(animationObject)
						animationObject->ClearComputedFrames();

					EnableMenuItem(GetMenu(hwnd), ID_RENDER_EXPANIMATION, MF_DISABLED| MF_GRAYED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_JULIAANIMATION, MF_DISABLED| MF_GRAYED);
					// Disable all menu items under "Fractal" menu
					EnableMenuItem(GetMenu(hwnd), ID_FRACTAL_MANDELBROT, MF_DISABLED| MF_GRAYED);
					EnableMenuItem(GetMenu(hwnd), ID_FRACTAL_JULIA, MF_DISABLED| MF_GRAYED);
					EnableMenuItem(GetMenu(hwnd), ID_FRACTAL_SETTINGS, MF_DISABLED| MF_GRAYED);
					EnableMenuItem(GetMenu(hwnd), ID_FRACTAL_RESET, MF_DISABLED| MF_GRAYED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_NONE, MF_DISABLED| MF_GRAYED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_LIGHT, MF_DISABLED| MF_GRAYED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_STRONG, MF_DISABLED| MF_GRAYED);
				break;
				case ID_RENDER_ZOOMANIMATION_END:
					if(path->GetStepCount() > 1){
						EnableMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_CREATE, MF_ENABLED);
						EnableMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_END, MF_DISABLED| MF_GRAYED);
						EnableMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_START, MF_ENABLED);
						path->m_active = false;
					}
					else
					{
						EnableMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_END, MF_DISABLED| MF_GRAYED);
						EnableMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_START, MF_ENABLED);
						path->m_active = false;
					}
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_EXPANIMATION, MF_ENABLED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_JULIAANIMATION, MF_ENABLED);

					// Enable all menu items under "Fractal" menu
					EnableMenuItem(GetMenu(hwnd), ID_FRACTAL_MANDELBROT, MF_ENABLED);
					EnableMenuItem(GetMenu(hwnd), ID_FRACTAL_JULIA, MF_ENABLED);
					EnableMenuItem(GetMenu(hwnd), ID_FRACTAL_SETTINGS, MF_ENABLED);
					EnableMenuItem(GetMenu(hwnd), ID_FRACTAL_RESET, MF_ENABLED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_NONE, MF_ENABLED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_LIGHT, MF_ENABLED);
					EnableMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_STRONG, MF_ENABLED);

				break;
				case ID_RENDER_ZOOMANIMATION_CREATE:
					DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_ANIMATIONM), hwnd, DlgMoveAnimationProc);
				break;
				case ID_RENDER_ZOOMANIMATION_FULLPATH:
					recordFullPath = !recordFullPath;
					if(recordFullPath)
						CheckMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_FULLPATH, MF_CHECKED);
					else
						CheckMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_FULLPATH, MF_UNCHECKED);
				break;
				case ID_RENDER_JULIAANIMATION:
					ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_JULIAANIM), hwnd, DlgJuliaAnimProc);
				break;
				case ID_RENDER_BLUR_NONE:
					if(fractalControl->GetFractalObject()->GetBlurStrength() == 0)
						return 0;
					fractalControl->GetFractalObject()->SetBlurStrength(0);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_NONE, MF_CHECKED);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_LIGHT, MF_UNCHECKED);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_STRONG, MF_UNCHECKED);
				break;
				case ID_RENDER_BLUR_LIGHT:
					if(fractalControl->GetFractalObject()->GetBlurStrength() == 1)
						return 0;
					fractalControl->GetFractalObject()->SetBlurStrength(1);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_NONE, MF_UNCHECKED);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_LIGHT, MF_CHECKED);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_STRONG, MF_UNCHECKED);
				break;
				case ID_RENDER_BLUR_STRONG:
					if(fractalControl->GetFractalObject()->GetBlurStrength() == 2)
						return 0;
					fractalControl->GetFractalObject()->SetBlurStrength(2);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_NONE, MF_UNCHECKED);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_LIGHT, MF_UNCHECKED);
					CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_STRONG, MF_CHECKED);
				break;
				case ID_FRACTAL_MANDELBROT:
					if(fractalControl->GetFractalType() != FRACTAL_TYPE_MAND)
					{
						SetMenu(hwnd, menuMand);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_MANDELBROT, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_JULIA, MF_UNCHECKED);
					
						CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_NONE, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_LIGHT, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_STRONG, MF_UNCHECKED);
					
						fractalControl->SetCurrentMandelbrot();

						if(recordFullPath)
							CheckMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_FULLPATH, MF_CHECKED);
						else
							CheckMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_FULLPATH, MF_UNCHECKED);

						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_1, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_2, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_0, MF_UNCHECKED);

						fractalControl->GetFractalObject()->SetCustomIndexIncrement(customIndexIncMand);
						fractalControl->GetFractalObject()->SetCustomIndexValue(customIndexValueMand);
						fractalControl->GetFractalObject()->SetCustomPalette(customPaletteMand, customPaletteSizeMand);
					}
				break;
				case ID_FRACTAL_JULIA:
					ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_JULIA), hwnd, JuliaDlgProc);
					if(ret == IDOK)
					{
						SetMenu(hwnd, menuJulia);

						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_MANDELBROT, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_JULIA, MF_CHECKED);
						
						CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_NONE, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_LIGHT, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_RENDER_BLUR_STRONG, MF_UNCHECKED);

						if(recordFullPath)
							CheckMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_FULLPATH, MF_CHECKED);
						else
							CheckMenuItem(GetMenu(hwnd), ID_RENDER_ZOOMANIMATION_FULLPATH, MF_UNCHECKED);
						
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_1, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_0, MF_UNCHECKED);

						fractalControl->GetFractalObject()->SetCustomIndexIncrement(customIndexIncJulia);
						fractalControl->GetFractalObject()->SetCustomIndexValue(customIndexValueJulia);
						fractalControl->GetFractalObject()->SetCustomPalette(customPaletteJulia, customPaletteSizeJulia);
					}
				break;
				case ID_FRACTAL_SETTINGS:
					if(fractalControl->GetFractalType() == FRACTAL_TYPE_MAND)
					{
						ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_SETTINGS), hwnd, DlgSettingsProc);
						if(ret == IDOK)
						{
							fractalControl->GetFractalObject()->SetFractal(x,y,iterations,zoom,mexp);
							timer->Start();
							fractalControl->GetFractalObject()->Compute();
						}
					}
					if(fractalControl->GetFractalType() == FRACTAL_TYPE_JULIA)
					{
						ret = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_SETTINGS_JULIA), hwnd, DlgSettingsJuliaProc);
						if(ret == IDOK)
						{
							fractalControl->GetFractalObject()->SetFractal(x,y,iterations,zoom,mexp);
							((CJulia*)fractalControl->GetFractalObject())->SetSeed(seedX, seedY);
							timer->Start();
							fractalControl->GetFractalObject()->Compute();
						}
					}
				break;
				case ID_FRACTAL_RESET:
					fractalControl->GetFractalObject()->Reset();
					fractalControl->GetFractalObject()->Compute();
					//fractalControl->SetData(defaultMandBig);
				break;
				case ID_FRACTAL_ITER_INC:
					fractalControl->IncreaseIterationCount();
				break;
				case ID_FRACTAL_ITER_DEC:
					fractalControl->DecreaseIterationCount();
				break;
				case ID_FRACTAL_COLOR_NORMAL:
					if(fractalControl->GetFractalObject()->GetColoring() == COLORING_SMOOTH)
					{
						fractalControl->GetFractalObject()->SetColoring(COLORING_NORMAL);
						fractalControl->GetFractalObject()->Compute();
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_COLOR_NORMAL, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_COLOR_SMOOTH, MF_UNCHECKED);
					}
				break;
				case ID_FRACTAL_COLOR_SMOOTH:
					if(fractalControl->GetFractalObject()->GetColoring() == COLORING_NORMAL)
					{
						fractalControl->GetFractalObject()->SetColoring(COLORING_SMOOTH);
						fractalControl->GetFractalObject()->Compute();
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_COLOR_NORMAL, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_COLOR_SMOOTH, MF_CHECKED);
					}
				break;
				case ID_FRACTAL_PALETTE_0:
					if(fractalControl->GetFractalObject()->GetActualPaletteIndex() != -1)
					{
						fractalControl->GetFractalObject()->SetActualPalette(PALETTE_CUSTOM);
						timer->Start();
						fractalControl->GetFractalObject()->Compute();
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_0, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_1, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_2, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_3, MF_UNCHECKED);
					}
					break;
				case ID_FRACTAL_PALETTE_1:
					if(fractalControl->GetFractalObject()->GetActualPaletteIndex() != 0)
					{
						fractalControl->GetFractalObject()->SetActualPalette(0);
						timer->Start();
						fractalControl->GetFractalObject()->Compute();
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_1, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_2, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_0, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_3, MF_UNCHECKED);
					}
				break;
				case ID_FRACTAL_PALETTE_2:
					if(fractalControl->GetFractalObject()->GetActualPaletteIndex() != 1)
					{
						fractalControl->GetFractalObject()->SetActualPalette(1);
						timer->Start();
						fractalControl->GetFractalObject()->Compute();
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_0, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_1, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_2, MF_CHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_3, MF_UNCHECKED);
					}
				break;
				case ID_FRACTAL_PALETTE_3:
					if(fractalControl->GetFractalObject()->GetActualPaletteIndex() != 2)
					{
						fractalControl->GetFractalObject()->SetActualPalette(2);
						timer->Start();
						fractalControl->GetFractalObject()->Compute();
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_0, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_1, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_2, MF_UNCHECKED);
						CheckMenuItem(GetMenu(hwnd), ID_FRACTAL_PALETTE_3, MF_CHECKED);
					}
					break;
				case ID_FRACTAL_PALETTE_CUSTOM:
					DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_PALETTE), hwnd, DlgPaletteProc);
				break;
			}
		break;
		case WM_CALCUPDATE:
			strProgress.str("");
			strProgress << computationStatus++*10 << " %";
			SetWindowText(hwndStatusBar, strProgress.str().c_str());
		break;
		case WM_CALCDONE:
			computationStatus = 0;
			timer->Stop();
			ist << "Done in " << timer->GetTime()/1000.0f << " seconds";
			//string s = "Done in "
			SetWindowText(hwndStatusBar, ist.str().c_str());
			threadsFinished++;
			if(threadsFinished == threadManager->GetThreadCount())
			{
				if(initialCalc)
				{
					fractalControl->SetData(defaultMandBig);
					initialCalc = false;
					defaultMandSmall->Compute();
				}
				InvalidateRect(fractalControl->GetHandle(), NULL, false);
				threadsFinished = 0;
			}
		break;
	    case WM_CLOSE:
            DestroyWindow(hwnd);
        break;
        case WM_DESTROY:
            PostQuitMessage(0);
        break;
		case WM_SIZE:
			SendMessage(hwndStatusBar, WM_SIZE, wParam, lParam);
		break;
        default:
            return DefWindowProc(hwnd, msg, wParam, lParam);
    }
    return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
{
    WNDCLASSEX wc;
    MSG Msg;

	instance = hInstance;

    //register the window class
    wc.cbSize        = sizeof(WNDCLASSEX);
    wc.style         = 0;
    wc.lpfnWndProc   = WndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.lpszMenuName  = 0;
    wc.lpszClassName = m_className;
    wc.hIconSm       = LoadIcon(NULL, IDI_APPLICATION);

	menuMand = LoadMenu(hInstance, MAKEINTRESOURCE(IDR_MENU1));
	menuJulia = LoadMenu(hInstance, MAKEINTRESOURCE(IDR_MENU2));


    if(!RegisterClassEx(&wc))
    {
        MessageBox(NULL, "Window Registration Failed!", "Error!",
            MB_ICONEXCLAMATION | MB_OK);
        return 0;
    }

	threadManager = new CThreadManager();
	timer = new CTimer();

	// get sizes of nonclient window areas
	int menuHeight = GetSystemMetrics(SM_CYMENU);
	int borderWidth = GetSystemMetrics(SM_CXBORDER);
	int borderHeight = GetSystemMetrics(SM_CYBORDER);
	int captionHeight = GetSystemMetrics(SM_CYCAPTION);
	int statusBarHeight = 25;

    //creating the window
    g_hwnd = CreateWindowEx(
        0,
        m_className,
        "AFractal",
		WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
        CW_USEDEFAULT, CW_USEDEFAULT, 640 + 2*borderWidth, 512 + menuHeight + captionHeight + borderHeight + statusBarHeight,		
        NULL, NULL, hInstance, NULL);

    if(g_hwnd == NULL)
    {
        MessageBox(NULL, "Window Creation Failed!", "Error!",
            MB_ICONEXCLAMATION | MB_OK);
        return false;
    }

	hwndStatusBar = CreateWindowEx(0,
								   STATUSCLASSNAME,
								   TEXT(" Done"),
								   WS_CHILD | WS_VISIBLE,
								   0, 0, 0, 0,
								   g_hwnd,
								   (HMENU)NULL,
								   instance,
								   NULL);
	if(hwndStatusBar == NULL)
		return false;

	fractalControl = new CControlFractal(g_hwnd, defaultMandBig);

	CreateDefCustomPalettes();

	ShowWindow(g_hwnd, nCmdShow);
    UpdateWindow(g_hwnd);
	
	// The Message Loop
    while(GetMessage(&Msg, NULL, 0, 0) > 0)
    {
        TranslateMessage(&Msg);
        DispatchMessage(&Msg);
    }
    return Msg.wParam;
}

char* SaveBmpFile(HWND hwnd) 
{
    char *filename = new char[MAX_PATH+1]; 
	
    char selectedFilename[MAX_PATH+1] = "";
        
    OPENFILENAME sfn = { 0 };
    sfn.lStructSize = sizeof(OPENFILENAME);
    sfn.hwndOwner = hwnd;
    sfn.lpstrFilter = "BitMap Files\0*.bmp\0";
    sfn.lpstrFile = selectedFilename;
    sfn.nMaxFile = MAX_PATH;
    sfn.lpstrTitle = "Save File";
    sfn.Flags = OFN_OVERWRITEPROMPT;
    sfn.lpstrDefExt = "bmp";
        
    if (!GetSaveFileName(&sfn))
	{
	    return NULL;
    }
	memcpy(filename, selectedFilename, MAX_PATH+1);
    return filename;
}

char* SaveAviFile(HWND hwnd) 
{
    char *filename = new char[MAX_PATH+1]; 
	
    char selectedFilename[MAX_PATH+1] = "";
	    
    OPENFILENAME sfn = { 0 };
    sfn.lStructSize = sizeof(OPENFILENAME);
    sfn.hwndOwner = hwnd;
    sfn.lpstrFilter = "Avi Files\0*.avi\0";
    sfn.lpstrFile = selectedFilename;
    sfn.nMaxFile = MAX_PATH;
    sfn.lpstrTitle = "Save File";
    sfn.Flags = OFN_OVERWRITEPROMPT;
    sfn.lpstrDefExt = "avi";
        
    if (!GetSaveFileName(&sfn))
	{
	    return NULL;
    }
	memcpy(filename, selectedFilename, MAX_PATH+1);
    return filename;
}