#ifndef CANIMOBJECT_H
#define CANIMOBJECT_H

#include <string>
#include <vector>
#include "windows.h"			// included for HWND

#define EXP_ANIM_OBJECT		1
#define MOVE_ANIM_OBJECT	2
#define JULIA_ANIM_OBJECT	3

class Avi;
class CFractal;

class CAnimObject{
protected:
	int m_numFrames;
	int m_prevNumFrames;
	int m_FPS;
	int m_actualFrame;
	int m_finishedFrameCount;
	int m_quality;
	CFractal **m_frames;
	bool m_animReady;		// animation is completely calculated
	Avi *m_avi;

	HWND m_hwnd;
public:
	int m_animObjectType;
	CAnimObject();
	~CAnimObject();
	int GetNumFrames() { return m_numFrames; };
	void SetNumFrames(int n) { m_numFrames = n; };
	int GetFPS() { return m_FPS; };
	//virtual void ComputeNextFrame() {};						
	CFractal *GetActualFrame() { return m_frames[m_actualFrame++]; };
	int GetActual() { return m_actualFrame; };
	bool IsReady() { return m_finishedFrameCount == m_numFrames; };
	void Reset() { m_actualFrame = 0; };
	void SetFPS(int fps) { m_FPS = fps; };
	void FrameFinished() { m_finishedFrameCount++; };
	// returns false if all frames are alreade calculated or being computed now
	bool NextFrameExists() { return m_actualFrame != m_numFrames; };
	void CreateAVI(std::string const& filename, int fps, HWND parrent);
	//void AbortComputing();
	virtual void Compute() = 0;
	

	CFractal *GetFrame(int i) {	return m_frames[i]; };

	void SetQuality(int i) { m_quality = i; };
	int GetQuality() { return m_quality; };
	void SetHandle(HWND hwnd);

	int GetFinishedFrameCount() { return m_finishedFrameCount; };
	virtual void Clear(int quality, CFractal *model = NULL){};
	void ClearComputedFrames() { m_finishedFrameCount = 0; };
};

#endif //CANIMATIONOBJECT_H