#include "CAnimationPath.h"

CAnimationPath::CAnimationPath()
: m_nd(2),
  m_active(false),
  m_fullPath(false)
{
	m_numSteps = 0;
	m_m = m_nd+m_numSteps+1;
	m_a = NULL;
	m_b = NULL;
	m_c = NULL;
	m_d = NULL;

	m_tVector = new double[m_m + 1];
}

CAnimationPath::~CAnimationPath()
{
	m_steps.clear();
}

void CAnimationPath::Add(long double zoomDepth,long double xMin, long double xMax, 
						 long double yMin, long double yMax, long double exp, int interationCount)
{
	fractalData data;
	
	data.m_exp = exp;
	data.m_iterationCount = interationCount;
	data.m_xMax = xMax;
	data.m_xMin = xMin;
	data.m_yMax = yMax;
	data.m_yMin = yMin;
	data.m_zoomDepth = zoomDepth;

	m_steps.push_back(data);
	m_numSteps++;
	m_m = m_nd+m_numSteps+1;
	
	delete [] m_tVector;
	m_tVector = new double[m_m + 1];
	for(int i = 0; i < m_m + 1; i++)
		m_tVector[i] = i;
}

void CAnimationPath::RemoveLast()
{
	if(m_steps.size() > 0)
	{
		m_steps.pop_back();
		--m_numSteps;
	}
}

void CAnimationPath::Clear()
{
	m_steps.clear();
	m_numSteps = 0;

	m_m = m_nd+m_numSteps+1;

	delete [] m_tVector;
	m_tVector = new double[m_m + 1];
	for(int i = 0; i < m_m + 1; i++)
		m_tVector[i] = i;
}

double CAnimationPath::ComputeN(char i, char k, double t)
{
	if(k == 0)
		if(t >= m_tVector[i] && t < m_tVector[i+1])
			return 1;
		else 
			return 0;
	else{
		double firstpart, secondpart;
		if (m_tVector[i+k] - m_tVector[i] == 0)
			firstpart = 0;
		else
			firstpart = (t - m_tVector[i])/(m_tVector[i+k] - m_tVector[i]); 
		if(m_tVector[i+k+1] - m_tVector[i+1] == 0)
			secondpart = 0;
		else 
			secondpart = (m_tVector[i+k+1] - t)/(m_tVector[i+k+1] - m_tVector[i+1]);
		return firstpart*ComputeN(i, k-1, t) + secondpart*ComputeN(i+1, k-1, t);
	}
}

void CAnimationPath::ComputeS(fractalData *v, double t)
{
	fractalData result;
	fractalData tmp;
	memset(&result, 0, sizeof(fractalData));
	double divisor = 0;
	for(unsigned int i = 0; i < m_steps.size(); i++)
	{
		tmp = m_steps.at(i);
		result.m_exp = result.m_exp + (tmp.m_exp)*ComputeN(i, m_nd, t);
		result.m_iterationCount = result.m_iterationCount + int(tmp.m_iterationCount*ComputeN(i, m_nd, t));
		result.m_xMax = result.m_xMax + tmp.m_xMax*ComputeN(i, m_nd, t);
		result.m_xMin = result.m_xMin + tmp.m_xMin*ComputeN(i, m_nd, t);
		result.m_yMax = result.m_yMax + tmp.m_yMax*ComputeN(i, m_nd, t);
		result.m_yMin = result.m_yMin + tmp.m_yMin*ComputeN(i, m_nd, t);
		result.m_zoomDepth = result.m_zoomDepth + tmp.m_zoomDepth*ComputeN(i, m_nd, t);
	}
	for(unsigned int i = 0; i < m_steps.size(); i++)
		divisor += ComputeN(i, m_nd, t);
	if(divisor != 0)
	{
		v->m_exp = result.m_exp/divisor;
		v->m_iterationCount = (int)(result.m_iterationCount/divisor);
		v->m_xMax = result.m_xMax/divisor;
		v->m_xMin = result.m_xMin/divisor;
		v->m_yMax = result.m_yMax/divisor;
		v->m_yMin = result.m_yMin/divisor;
		v->m_zoomDepth = result.m_zoomDepth;
	}
	else
	{
		v->m_exp = 0;
		v->m_iterationCount = 0;
		v->m_xMax = 0;
		v->m_xMin = 0;
		v->m_yMax = 0;
		v->m_yMin = 0;
		v->m_zoomDepth = 0;
	}
}

fractalData CAnimationPath::GetPartial(int i, int stepFrames)
{
	if(m_numSteps < 3)
		i *= 2;
	else
		i = int((i/(double)(stepFrames*(m_numSteps-1)))*(stepFrames*m_numSteps));

	fractalData n;
	double u = (double)(i%stepFrames)/(double)stepFrames + i/stepFrames + m_tVector[m_nd-1]; 
	ComputeS(&n, u);
	return n;
}

void CAnimationPath::RecalcPath()
{
	if(m_steps.size() < 2)
		return;

	const int n = m_steps.size() - 1;

	float *gamma = new float[n+1];
	fractalData *delta = new fractalData[n+1];
	fractalData *D = new fractalData[n+1];

	gamma[0] = 0.5;
	for(int i = 1; i < n; i++)
		gamma[i] = 1/(4 - gamma[i-1]);
	gamma[n] = 1/(2 - gamma[n-1]);

	delta[0].m_zoomDepth = 1.5f*gamma[0]*(m_steps.at(1).m_zoomDepth - m_steps.at(0).m_zoomDepth);
	delta[0].m_iterationCount = (int)(1.5f*gamma[0]*(m_steps.at(1).m_iterationCount - m_steps.at(0).m_iterationCount));
	delta[0].m_xMin = 1.5f*gamma[0]*(m_steps.at(1).m_xMin - m_steps.at(0).m_xMin);
	delta[0].m_xMax = 1.5f*gamma[0]*(m_steps.at(1).m_xMax - m_steps.at(0).m_xMax);
	delta[0].m_yMin = 1.5f*gamma[0]*(m_steps.at(1).m_yMin - m_steps.at(0).m_yMin);
	delta[0].m_yMax = 1.5f*gamma[0]*(m_steps.at(1).m_yMax - m_steps.at(0).m_yMax);

	for(int i = 1; i < n; i++)
	{
		delta[i].m_zoomDepth = (3*(m_steps.at(i+1).m_zoomDepth - m_steps.at(i-1).m_zoomDepth) - delta[i-1].m_zoomDepth)*gamma[i];
		delta[i].m_iterationCount = 3*(m_steps.at(i+1).m_iterationCount - m_steps.at(i-1).m_iterationCount) - (int)((delta[i-1].m_iterationCount)*gamma[i]);
		delta[i].m_xMin = (3*(m_steps.at(i+1).m_xMin - m_steps.at(i-1).m_xMin) - delta[i-1].m_xMin)*gamma[i];
		delta[i].m_xMax = (3*(m_steps.at(i+1).m_xMax - m_steps.at(i-1).m_xMax) - delta[i-1].m_xMax)*gamma[i];
		delta[i].m_yMin = (3*(m_steps.at(i+1).m_yMin - m_steps.at(i-1).m_yMin) - delta[i-1].m_yMin)*gamma[i];
		delta[i].m_yMax = (3*(m_steps.at(i+1).m_yMax - m_steps.at(i-1).m_yMax) - delta[i-1].m_yMax)*gamma[i];
	}
	delta[n].m_zoomDepth = (3*(m_steps.at(n).m_zoomDepth - m_steps.at(n-1).m_zoomDepth) - delta[n-1].m_zoomDepth)*gamma[n];
	delta[n].m_iterationCount = 3*(m_steps.at(n).m_iterationCount - m_steps.at(n-1).m_iterationCount) - (int)((delta[n-1].m_iterationCount)*gamma[n]);
	delta[n].m_xMin = (3*(m_steps.at(n).m_xMin - m_steps.at(n-1).m_xMin) - delta[n-1].m_xMin)*gamma[n];
	delta[n].m_xMax = (3*(m_steps.at(n).m_xMax - m_steps.at(n-1).m_xMax) - delta[n-1].m_xMax)*gamma[n];
	delta[n].m_yMin = (3*(m_steps.at(n).m_yMin - m_steps.at(n-1).m_yMin) - delta[n-1].m_yMin)*gamma[n];
	delta[n].m_yMax = (3*(m_steps.at(n).m_yMax - m_steps.at(n-1).m_yMax) - delta[n-1].m_yMax)*gamma[n];

	D[n] = delta[n];
	for(int i = n - 1; i >= 0; i--)
	{
		D[i].m_zoomDepth = delta[i].m_zoomDepth - gamma[i]*D[i+1].m_zoomDepth;
		D[i].m_iterationCount = delta[i].m_iterationCount - (int)(gamma[i]*D[i+1].m_iterationCount);
		D[i].m_xMin = delta[i].m_xMin - gamma[i]*D[i+1].m_xMin;
		D[i].m_xMax = delta[i].m_xMax - gamma[i]*D[i+1].m_xMax;
		D[i].m_yMin = delta[i].m_yMin - gamma[i]*D[i+1].m_yMin;
		D[i].m_yMax = delta[i].m_yMax - gamma[i]*D[i+1].m_yMax;
	}

	if(m_a != NULL)
		delete[] m_a;
	if(m_b != NULL)
		delete[] m_b;
	if(m_c != NULL)
		delete[] m_c;
	if(m_d != NULL)
		delete[] m_d;

	m_a = new fractalData[n];
	m_b = new fractalData[n];
	m_c = new fractalData[n];
	m_d = new fractalData[n];

	for(int i = 0; i < n; i++)
	{
		m_a[i].m_zoomDepth = m_steps.at(i).m_zoomDepth;
		m_a[i].m_iterationCount = m_steps.at(i).m_iterationCount;
		m_a[i].m_xMin = m_steps.at(i).m_xMin;
		m_a[i].m_xMax = m_steps.at(i).m_xMax;
		m_a[i].m_yMin = m_steps.at(i).m_yMin;
		m_a[i].m_yMax = m_steps.at(i).m_yMax;
		
		m_b[i] = D[i];

		m_c[i].m_zoomDepth = 3*(m_steps.at(i+1).m_zoomDepth - m_steps.at(i).m_zoomDepth) - 2*D[i].m_zoomDepth - D[i+1].m_zoomDepth;
		m_c[i].m_iterationCount = 3*(m_steps.at(i+1).m_iterationCount - m_steps.at(i).m_iterationCount) - 2*D[i].m_iterationCount - D[i+1].m_iterationCount;
		m_c[i].m_xMin = 3*(m_steps.at(i+1).m_xMin - m_steps.at(i).m_xMin) - 2*D[i].m_xMin - D[i+1].m_xMin;
		m_c[i].m_xMax = 3*(m_steps.at(i+1).m_xMax - m_steps.at(i).m_xMax) - 2*D[i].m_xMax - D[i+1].m_xMax;
		m_c[i].m_yMin = 3*(m_steps.at(i+1).m_yMin - m_steps.at(i).m_yMin) - 2*D[i].m_yMin - D[i+1].m_yMin;
		m_c[i].m_yMax = 3*(m_steps.at(i+1).m_yMax - m_steps.at(i).m_yMax) - 2*D[i].m_yMax - D[i+1].m_yMax;
		
		m_d[i].m_zoomDepth = 2*(m_steps.at(i).m_zoomDepth - m_steps.at(i+1).m_zoomDepth) + D[i].m_zoomDepth + D[i+1].m_zoomDepth;
		m_d[i].m_iterationCount = 2*(m_steps.at(i).m_iterationCount - m_steps.at(i+1).m_iterationCount) + D[i].m_iterationCount + D[i+1].m_iterationCount;
		m_d[i].m_xMin = 2*(m_steps.at(i).m_xMin - m_steps.at(i+1).m_xMin) + D[i].m_xMin + D[i+1].m_xMin;
		m_d[i].m_xMax = 2*(m_steps.at(i).m_xMax - m_steps.at(i+1).m_xMax) + D[i].m_xMax + D[i+1].m_xMax;
		m_d[i].m_yMin = 2*(m_steps.at(i).m_yMin - m_steps.at(i+1).m_yMin) + D[i].m_yMin + D[i+1].m_yMin;
		m_d[i].m_yMax = 2*(m_steps.at(i).m_yMax - m_steps.at(i+1).m_yMax) + D[i].m_yMax + D[i+1].m_yMax;
	}

	delete[] gamma;
	delete[] delta;
}