#ifndef CANIMATIONPATH_H
#define CANIMATIONPATH_H

#include <vector>

//#define PATH_SPLINE 1
//#define PATH_NURBS 2

typedef struct fractalData
{
	long double m_zoomDepth;
	long double m_xMin;
	long double m_xMax;
	long double m_yMin;
	long double m_yMax;
	long double m_exp;					
	int m_iterationCount;
}fractalData;

class CAnimationPath
{
private:
	int m_numSteps;
	std::vector<fractalData> m_steps;

	// variables for natural cubic spline
	fractalData *m_a;
	fractalData *m_b;
	fractalData *m_c;
	fractalData *m_d;
	
	int m_nd;
	int m_m;
	double *m_tVector;

	double ComputeN(char i, char k, double t);
	void ComputeS(fractalData *v, double t);

	bool m_fullPath;
public:
	bool m_active;						// true if we are recording movement
	CAnimationPath();
	~CAnimationPath();

	void Add(long double m_zoomDepth,long double m_xMin, long double m_xMax, 
			 long double m_yMin, long double m_yMax, long double m_exp, int m_iterationCount);
	void RemoveLast();
	fractalData Get(int i) { return m_steps.at(i); };
	int GetStepCount() { return m_numSteps; };
	void Clear();
	void RecalcPath();
	fractalData GetPartial(int i, int stepFrames);
	void SetRecordFullPath(bool full) { m_fullPath = full; };
	bool GetRecordFullPath() { return m_fullPath; };
};

#endif //CANIMATIONPATH_H