#include "CControlColor.h"
#include "stdio.h"

LRESULT CALLBACK CControlColor::CustWndProcWrapper00(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer00");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper01(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer01");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper02(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer02");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper03(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer03");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper04(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer04");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper05(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer05");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper06(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer06");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper07(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer07");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper08(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer08");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper09(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer09");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper10(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer10");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper11(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer11");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper12(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer12");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper13(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer13");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
LRESULT CALLBACK CControlColor::CustWndProcWrapper14(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlColor *pThis = (CControlColor*)GetProp(hwnd,"ClassPointer14");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT CControlColor::CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps; 
	HDC hdc; 

    switch(msg)
    {
	case WM_PAINT:
		if(wParam == 0)
			hdc = BeginPaint(hwnd, &ps);
		else
			hdc = (HDC)wParam;

		OnPaint(hdc);

		if(wParam == 0)
			EndPaint(hwnd, &ps);
	break;
	case WM_LBUTTONDOWN:
		OnLButtonDown(wParam, lParam);
	break;
	default:
        break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

CControlColor::CControlColor(HWND hwndParent, int index)
: CCustomColorControl(hwndParent),
  m_selected(false),
  m_index(index)
{
	HDC hdc;
	m_width = 32;
	m_height = 32;

	char a[] = "Custom control color";
	m_className = new char[23];
	memcpy(m_className, a, (sizeof(char))*20);
	m_className[20] = '0' + index/10;
	m_className[21] = '0' + index%10;
	m_className[22] = '\0';

	InitCustomControl();
	CreateCustomControl();

	m_bitmapInfo.biSize = sizeof(BITMAPINFOHEADER);
	m_bitmapInfo.biWidth = m_width;
	m_bitmapInfo.biHeight = m_height;
	m_bitmapInfo.biPlanes = 1;
	m_bitmapInfo.biBitCount = 24;
	m_bitmapInfo.biCompression = BI_RGB;
	m_bitmapInfo.biSizeImage = 0;
	m_bitmapInfo.biXPelsPerMeter = 0;
	m_bitmapInfo.biYPelsPerMeter = 0;
	m_bitmapInfo.biClrUsed = 0;
	m_bitmapInfo.biClrImportant = 0;

	hdc = GetWindowDC(NULL);

	m_hBitmap = CreateDIBSection(hdc, (LPBITMAPINFO)&m_bitmapInfo,DIB_RGB_COLORS,(LPVOID *)&m_palette,NULL,0);

	GenerateBitmap();

	ReleaseDC(NULL,hdc);
}

CControlColor::~CControlColor()
{
	delete m_className;
	DeleteObject(m_hBitmap);
}

void CControlColor::InitCustomControl()
{
	WNDCLASSEX wc;
    
    wc.cbSize         = sizeof(wc);
    wc.lpszClassName  = m_className;
    wc.hInstance      = GetModuleHandle(0);
    wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
    wc.hIcon          = 0;
    wc.lpszMenuName   = 0;
    wc.hbrBackground  = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.style          = 0;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hIconSm        = 0;

	switch(m_index)
	{
		case 0:	wc.lpfnWndProc = CustWndProcWrapper00; break;
		case 1:	wc.lpfnWndProc = CustWndProcWrapper01; break;
		case 2: wc.lpfnWndProc = CustWndProcWrapper02; break;
		case 3:	wc.lpfnWndProc = CustWndProcWrapper03; break;
		case 4:	wc.lpfnWndProc = CustWndProcWrapper04; break;
		case 5:	wc.lpfnWndProc = CustWndProcWrapper05; break;
		case 6:	wc.lpfnWndProc = CustWndProcWrapper06; break;
		case 7:	wc.lpfnWndProc = CustWndProcWrapper07; break;
		case 8:	wc.lpfnWndProc = CustWndProcWrapper08; break;
		case 9:	wc.lpfnWndProc = CustWndProcWrapper09; break;
		case 10: wc.lpfnWndProc = CustWndProcWrapper10; break;
		case 11: wc.lpfnWndProc = CustWndProcWrapper11;	break;
		case 12: wc.lpfnWndProc = CustWndProcWrapper12;	break;
		case 13: wc.lpfnWndProc = CustWndProcWrapper13;	break;
		case 14: wc.lpfnWndProc = CustWndProcWrapper14;	break;
	}

    RegisterClassEx(&wc);
}


void CControlColor::CreateCustomControl()
{
	int x,y;
	if(m_index == 0)
	{
		m_r = 0;
		m_g = 0;
		m_b = 0;
		m_h = m_s = m_v = 0;
		x = 10;
		y = 45;
	}
	else
	{
		m_r = 150;
		m_g = 150;
		m_b = 150;
		m_h = 0;
		m_s = 0;
		m_v = 150.0f/255.0f;
		if(m_index < 7)
		{
			x = (m_index+1)*10 + m_index*32;
			y = 45;
		}
		else
		{
			x = (m_index-6)*10 + (m_index - 7)*32;
			y = 87;
		}
	}
	
	char a[] = "Custom control color";
	char b[23];
	memcpy(b, a, (sizeof(char))*20);
	b[20] = '0' + m_index/10;
	b[21] = '0' + m_index%10;
	b[22] = '\0';

	m_hwndCtrl = CreateWindowEx(
                 WS_EX_STATICEDGE, // give it a standard border
                 m_className,
                 _T(b),
                 WS_VISIBLE | WS_CHILD,
                 x, y, m_width + 2, m_height + 2,
                 m_hwndParent,
                 NULL, GetModuleHandle(0), NULL
               );

	char c[] = "ClassPointer";
	memcpy(b,c,sizeof(char)*12);
	b[12] = '0' + m_index/10;
	b[13] = '0' + m_index%10;
	b[14] = '\0';
	SetProp(m_hwndCtrl,b,(HANDLE)this);
}

void CControlColor::OnLButtonDown(WPARAM wParam, LPARAM lParam) 
{
	m_selected = true;
	GenerateBitmap();
	unsigned int i = (m_r << 16) + (m_g << 8) + m_b;
	InvalidateRect(m_hwndCtrl, NULL, false);
	PostMessage(m_hwndParent, WM_SET_RGB, WPARAM(i), NULL);
	PostMessage(m_hwndParent, WM_SELECT_COLOR_SLOT, WPARAM(m_index), NULL);
	long j = ((unsigned short)(m_h*360) << 16) + ((unsigned char)(m_s*100) << 8) + (unsigned char)(m_v*100);
	PostMessage(m_hwndParent, WM_SET_RGB_HSV, WPARAM(i), LPARAM(j));
}

void CControlColor::SetHS(float h, float s)
{
	rgb c;
	m_h = h;
	m_s = s;
	HSV2RGB(m_h, m_s, m_v, &c);
	m_r = c.r;
	m_g = c.g;
	m_b = c.b;
	GenerateBitmap();
	InvalidateRect(m_hwndCtrl, NULL, false);
	UpdateWindow(m_hwndCtrl);
}

void CControlColor::SetV(float v)
{
	rgb c;
	m_v = v;
	HSV2RGB(m_h, m_s, m_v, &c);
	m_r = c.r;
	m_g = c.g;
	m_b = c.b;
	GenerateBitmap();
	InvalidateRect(m_hwndCtrl, NULL, false);
	UpdateWindow(m_hwndCtrl);
}

void CControlColor::SetRGB(unsigned char r, unsigned char g, unsigned char b)
{
	if(r > 255)
		r = 255;
	if(g > 255)
		g = 255;
	if(b > 255)
		b = 255;

	hsv c;
	m_r = r;
	m_g = g;
	m_b = b;
	RGB2HSV(r,g,b,&c);
	m_v = c.v;
	m_h = c.h;
	m_s = c.s;
	GenerateBitmap();

	if(m_selected)
	{
		unsigned int i = (r << 16) + (g << 8) + b;
		long j = ((unsigned short)(m_h*360) << 16) + ((unsigned char)(m_s*100) << 8) + (unsigned char)(m_v*100);
		PostMessage(m_hwndParent, WM_SET_RGB_HSV, WPARAM(i), LPARAM(j));
	}
	
	InvalidateRect(m_hwndCtrl, NULL, false);
	UpdateWindow(m_hwndCtrl);
}

void CControlColor::SetHSV(short int h, unsigned char s, unsigned char v)
{
	if(h > 360)
		h = 360;
	if(s > 100)
		s = 100;
	if(v > 100)
		v = 100;

	m_v = (float)v/100.0f;
	m_h = (float)h/360.0f;
	m_s = (float)s/100.0f;

	rgb c;
	HSV2RGB(m_h, m_s, m_v, &c);
	m_r = c.r;
	m_g = c.g;
	m_b = c.b;
	GenerateBitmap();

	if(m_selected)
	{
		unsigned int i = (m_r << 16) + (m_g << 8) + m_b;
		long j = ((unsigned short)(m_h*360) << 16) + ((unsigned char)(m_s*100) << 8) + (unsigned char)(m_v*100);
		PostMessage(m_hwndParent, WM_SET_RGB_HSV, WPARAM(i), LPARAM(j));
	}

	InvalidateRect(m_hwndCtrl, NULL, false);
	UpdateWindow(m_hwndCtrl);
}

void CControlColor::SetSelected(bool selected)
{
	m_selected = selected;
	GenerateBitmap();
	rgb c;
	HSV2RGB(m_h, m_s, m_v, &c);
	unsigned int i = (c.r << 16) + (c.g << 8) + c.b;
	long j = ((unsigned short)(m_h*360) << 16) + ((unsigned char)(m_s*100) << 8) + (unsigned char)(m_v*100);
	PostMessage(m_hwndParent, WM_SET_RGB_HSV, WPARAM(i), LPARAM(j));
	InvalidateRect(m_hwndCtrl, NULL, false);
}

void CControlColor::GenerateBitmap()
{
	for(int i = 0; i < 32*32; i++)
	{
		m_palette[3*i] = m_b;
		m_palette[3*i+1] = m_g;
		m_palette[3*i+2] = m_r;
	}

}

void CControlColor::DrawSelection(HDC hdc)
{
	if(m_selected)
	{
		HPEN hPen, hpOld;
		hPen = CreatePen(PS_SOLID, 3, 0x00000000);
		hpOld = (HPEN)SelectObject(hdc, hPen);

		MoveToEx(hdc, 0, 0, NULL);
		LineTo(hdc, 31, 0);
		LineTo(hdc, 31, 31);
		LineTo(hdc, 0, 31);
		LineTo(hdc, 0, 0);

		SelectObject(hdc, hpOld);
		DeleteObject(hPen);  
	}
}