#ifndef CCONTROLCOLOR_H
#define CCONTROLCOLOR_H

#include "CCustomColorControl.h"

class CControlColor : public CCustomColorControl
{
private:
	bool m_selected;
	int m_index;

	void CreateCustomControl();
	void InitCustomControl();

	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	static LRESULT CALLBACK CustWndProcWrapper00(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper01(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper02(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper03(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper04(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper05(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper06(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper07(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper08(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper09(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper10(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper11(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper12(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper13(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper14(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	
	void GenerateBitmap();
	void DrawSelection(HDC hdc);	

	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
public:
	CControlColor(HWND hwndParent, int index);
	virtual ~CControlColor();

	void SetSelected(bool selected);
	bool GetSelected() { return m_selected; };
	void SetV(float v);
	void SetHS(float h, float s);
	void SetRGB(unsigned char r, unsigned char g, unsigned char b);
	void SetHSV(short int r, unsigned char g, unsigned char b);
	unsigned char GetB(){ return m_palette[0]; };
	unsigned char GetG(){ return m_palette[1]; };
	unsigned char GetR(){ return m_palette[2]; };
};

#endif // CCONTROLCOLOR_H
