#ifndef CCONTROLFRACTAL_H
#define CCONTROLFRACTAL_H

#define FRACTAL_TYPE_MAND 0
#define FRACTAL_TYPE_JULIA 1

#include "CCustomControl.h"

class CAnimationPath;
class CFractal;
class CMandelbrot;
class CAnimObject;

class CControlFractal : public CCustomControl
{
private:
	CAnimationPath *m_path;
	CFractal *m_fractalObject;
	int m_fractalType;

	unsigned char *m_image;

	int m_drag_x_s;
	int m_drag_y_s;
	int m_drag_x_e;
	int m_drag_y_e;
	bool m_dragging;

	void CreateCustomControl();
	void InitCustomControl();

	void DrawSelection(HDC hdc);

	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
public:
	CControlFractal(HWND hwndParent, CMandelbrot *def = NULL);
	virtual ~CControlFractal();

	void OnRButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonUp(WPARAM wParam, LPARAM lParam);
	void OnMouseMove(WPARAM wParam, LPARAM lParam);
	void OnKeyPress(WPARAM wParam);
	void IncreaseIterationCount();
	void DecreaseIterationCount();
	void SetData(CMandelbrot *data);
	void SetCurrentMandelbrot();
	//void SetCurrentJulia();
	void SetCurrentJulia(double x, double y);
	int GetFractalType() { return m_fractalType; };
	void SaveToBmp(const char *fileName, unsigned char *texture, int width, int height);
	void SetPathObject(CAnimationPath *path) { m_path = path; }; 
	CFractal *GetFractalObject() { return m_fractalObject; };
};

#endif // CCONTROLFRACTAL_H
