#include "CControlJulia.h"
#include "CJulia.h"
#include "stdio.h"

LRESULT CALLBACK CControlJulia::JuliaWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlJulia *pThis = (CControlJulia*)GetProp(hwnd,"ClassPointer");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT CControlJulia::CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps; 
	HDC hdc; 

    switch(msg)
    {
	case WM_PAINT:
		if(wParam == 0)
			hdc = BeginPaint(hwnd, &ps);
		else
			hdc = (HDC)wParam;

		OnPaint(hdc);

		if(wParam == 0)
			EndPaint(hwnd, &ps);
	break;
	default:
        break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

CControlJulia::CControlJulia(HWND hwndParent, int quality, long double seedX, long double seedY)
: CCustomControl(hwndParent),
  m_quality(quality),
  m_seedX(seedX), m_seedY(seedY)
{
	m_className = _T("ControlJulia");

	switch(m_quality)
	{
	case PREVIEW_QUALITY_ANIM:
	case PREVIEW_QUALITY_LOW:
		m_width = 160;
		m_height = 128;
		m_iterationCount = 128;
	break;
	case PREVIEW_QUALITY_MEDIUM:
		m_width = 320;
		m_height = 256;
		m_iterationCount = 64;
	break;
	case PREVIEW_QUALITY_HIGH:
		m_width = 320;
		m_height = 256;
		m_iterationCount = 128;
	break;
	}

	InitCustomControl();
	CreateCustomControl();

	m_fractalObject = new CJulia();
	m_fractalObject->SetHWND(hwndParent);
	m_fractalObject->SetSize(m_width, m_height);

	m_bitmapInfo.biSize = sizeof(BITMAPINFOHEADER);
	m_bitmapInfo.biWidth = m_width;
	m_bitmapInfo.biHeight = m_height;
	m_bitmapInfo.biPlanes = 1;
	m_bitmapInfo.biBitCount = 24;
	m_bitmapInfo.biCompression = BI_RGB;
	m_bitmapInfo.biSizeImage = 0;
	m_bitmapInfo.biXPelsPerMeter = 0;
	m_bitmapInfo.biYPelsPerMeter = 0;
	m_bitmapInfo.biClrUsed = 0;
	m_bitmapInfo.biClrImportant = 0;

	HDC hdc = GetWindowDC(NULL);

	m_hBitmap = CreateDIBSection(hdc, (LPBITMAPINFO)&m_bitmapInfo,DIB_RGB_COLORS,(LPVOID *)&m_image,NULL,0);

	m_fractalObject->SetMemoryLocation(m_image);
	m_fractalObject->SetIterationCount(m_iterationCount);
	m_fractalObject->SetSeed(m_seedX, m_seedY);
	m_fractalObject->Compute(0,1);

	ReleaseDC(NULL,hdc);
}

CControlJulia::~CControlJulia()
{
	delete m_fractalObject;
	DeleteObject(m_hBitmap);
}

void CControlJulia::InitCustomControl()
{
    WNDCLASSEX wc;
    
    wc.cbSize         = sizeof(wc);
    wc.lpszClassName  = m_className;
    wc.hInstance      = GetModuleHandle(0);
    wc.lpfnWndProc    = JuliaWndProcWrapper;
    wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
    wc.hIcon          = 0;
    wc.lpszMenuName   = 0;
    wc.hbrBackground  = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.style          = 0;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hIconSm        = 0;

    RegisterClassEx(&wc);
}


void CControlJulia::CreateCustomControl()
{
	int x,y;
	switch(m_quality)
	{
	case PREVIEW_QUALITY_LOW:
		x = 330 + m_width/4;
		y = 5 + m_height/4;
	break;
	case PREVIEW_QUALITY_MEDIUM:
	case PREVIEW_QUALITY_HIGH:
		x = 330;
		y = 5;
	break;
	case PREVIEW_QUALITY_ANIM:
		x = 650;
		y = 389;
	break;
	}
	m_hwndCtrl = CreateWindowEx(
                 WS_EX_CLIENTEDGE, // give it a standard border
                 m_className,
                 _T("control Julia"),
                 WS_VISIBLE | WS_CHILD,
                 x, y, m_width + 4, m_height + 4,
                 m_hwndParent,
                 NULL, GetModuleHandle(0), NULL
               );

	SetProp(m_hwndCtrl,"ClassPointer",(HANDLE)this);
}

void CControlJulia::SetQuality(int quality)
{
	m_quality = quality;
	int x,y;
	switch(m_quality)
	{
	case PREVIEW_QUALITY_LOW:
		x = 330 + m_width/4;
		y = 5 + m_height/4;
		m_width = 160;
		m_height = 128;
		m_iterationCount = 64;
	break;
	case PREVIEW_QUALITY_MEDIUM:
		m_width = 320;
		m_height = 256;
		x = 330;
		y = 5;
		m_iterationCount = 64;
	break;
	case PREVIEW_QUALITY_HIGH:
		m_width = 320;
		m_height = 256;
		x = 330;
		y = 5;
		m_iterationCount = 128;
	break;
	}

	DeleteObject(m_hBitmap);

	m_bitmapInfo.biSize = sizeof(BITMAPINFOHEADER);
	m_bitmapInfo.biWidth = m_width;
	m_bitmapInfo.biHeight = m_height;
	m_bitmapInfo.biPlanes = 1;
	m_bitmapInfo.biBitCount = 24;
	m_bitmapInfo.biCompression = BI_RGB;
	m_bitmapInfo.biSizeImage = 0;
	m_bitmapInfo.biXPelsPerMeter = 0;
	m_bitmapInfo.biYPelsPerMeter = 0;
	m_bitmapInfo.biClrUsed = 0;
	m_bitmapInfo.biClrImportant = 0;

	HDC hdc = GetWindowDC(NULL);

	m_hBitmap = CreateDIBSection(hdc, (LPBITMAPINFO)&m_bitmapInfo,DIB_RGB_COLORS,(LPVOID *)&m_image,NULL,0);

	m_fractalObject->SetSize(m_width, m_height);

	m_fractalObject->SetMemoryLocation(m_image);
	m_fractalObject->SetIterationCount(m_iterationCount);
	//m_fractalObject->SetSeed(m_seedX, m_seedY);
	m_fractalObject->Compute(0,1);

	ReleaseDC(NULL,hdc);

	SetWindowPos(m_hwndCtrl,0,x,y,m_width,m_height,SWP_NOZORDER);
	InvalidateRect(m_hwndCtrl, NULL, false);
}