#include "CControlMand.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "stdio.h"

#define WM_UPDATEPOSITION	WM_APP + 0x162

LRESULT CALLBACK CControlMand::MandWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CControlMand *pThis = (CControlMand*)GetProp(hwnd,"ClassPointer");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT CControlMand::CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps; 
	HDC hdc; 

    switch(msg)
    {
	case WM_PAINT:
		if(wParam == 0)
			hdc = BeginPaint(hwnd, &ps);
		else
			hdc = (HDC)wParam;

		OnPaint(hdc);

		if(wParam == 0)
			EndPaint(hwnd, &ps);
	break;
	case WM_LBUTTONDOWN:
		OnLButtonDown(LOWORD(lParam), HIWORD(lParam));
	break;
	case WM_LBUTTONUP:
		OnLButtonUp(LOWORD(lParam), HIWORD(lParam));
	break;
	case WM_MOUSEMOVE:
		if((wParam & MK_LBUTTON) != 0)						// is L left mouse button pressed?
			OnMouseMove(LOWORD(lParam), HIWORD(lParam));
	break;
	default:
        break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

CControlMand::CControlMand(HWND hwndParent, HWND hwndJulia, CFractal *julia, CMandelbrot *def) 
: CCustomControl(hwndParent),
  m_juliaObject(julia),
  m_hwndJulia(hwndJulia),
  m_mouseX(197), m_mouseY(188),
  m_pointX(-0.4), m_pointY(0.6)
{
	m_className = _T("ControlMand");
	m_width = 320;
	m_height = 256;

	InitCustomControl();
	CreateCustomControl();

	m_fractalObject = new CMandelbrot();
	m_fractalObject->SetSize(m_width, m_height);

	m_bitmapInfo.biSize = sizeof(BITMAPINFOHEADER);
	m_bitmapInfo.biWidth = m_width;
	m_bitmapInfo.biHeight = m_height;
	m_bitmapInfo.biPlanes = 1;
	m_bitmapInfo.biBitCount = 24;
	m_bitmapInfo.biCompression = BI_RGB;
	m_bitmapInfo.biSizeImage = 0;
	m_bitmapInfo.biXPelsPerMeter = 0;
	m_bitmapInfo.biYPelsPerMeter = 0;
	m_bitmapInfo.biClrUsed = 0;
	m_bitmapInfo.biClrImportant = 0;

	HDC hdc = GetWindowDC(NULL);

	m_hBitmap = CreateDIBSection(hdc, (LPBITMAPINFO)&m_bitmapInfo,DIB_RGB_COLORS,(LPVOID *)&m_image,NULL,0);

	m_fractalObject->SetMemoryLocation(m_image);
	m_fractalObject->SetIterationCount(64);
	m_fractalObject->Compute();

	ReleaseDC(NULL,hdc);

	if(def != NULL)
		m_fractalObject->SetTexture(def->GetImage(), def->GetSizeX()*def->GetSizeY()*sizeof(unsigned char)*3);
}

CControlMand::~CControlMand()
{
	delete m_fractalObject;
}

void CControlMand::InitCustomControl()
{
    WNDCLASSEX wc;
    
    wc.cbSize         = sizeof(wc);
    wc.lpszClassName  = m_className;
    wc.hInstance      = GetModuleHandle(0);
    wc.lpfnWndProc    = MandWndProcWrapper;
    wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
    wc.hIcon          = 0;
    wc.lpszMenuName   = 0;
    wc.hbrBackground  = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.style          = 0;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hIconSm        = 0;

    RegisterClassEx(&wc);
}


void CControlMand::CreateCustomControl()
{
	m_hwndCtrl = CreateWindowEx(
                 WS_EX_CLIENTEDGE, // give it a standard border
                 m_className,
                 _T("control Mand"),
                 WS_VISIBLE | WS_CHILD,
                 5, 5, m_width + 4, m_height + 4,
                 m_hwndParent,
                 NULL, GetModuleHandle(0), NULL
               );

	SetProp(m_hwndCtrl,"ClassPointer",(HANDLE)this);
}

void CControlMand::OnLButtonDown(int x, int y) 
{
	m_mouseX = x;
	m_mouseY = y;
	m_pointX = 3.0f*(float)x/(float)m_width-2.25f;
	m_pointY = -2.5f*(float)y/(float)m_height+1.25f;

	((CJulia *)m_juliaObject)->SetSeed(m_pointX, m_pointY);
	m_juliaObject->Compute(0,1);
	InvalidateRect(m_hwndCtrl, NULL, false);
	UpdateWindow(m_hwndCtrl);
	PostMessage(m_hwndParent, WM_UPDATEPOSITION, WPARAM(m_pointX*100000), LPARAM(m_pointY*100000));
}

void CControlMand::OnLButtonUp(int x, int y) 
{

}

void CControlMand::SetPointPossition(long double x, long double y)
{
	m_pointX = x;
	m_pointY = y;

	m_mouseX = (int)((x+2.25)/3*m_width);
	m_mouseY = (int)(m_height - (y+1.25)/2.5*m_height);

	((CJulia *)m_juliaObject)->SetSeed(m_pointX, m_pointY);
	m_juliaObject->Compute(0,1);
	InvalidateRect(m_hwndCtrl, NULL, false);
	UpdateWindow(m_hwndCtrl);
}

void CControlMand::OnMouseMove(int x, int y)
{
	m_mouseX = x;
	m_mouseY = y;
	m_pointX = 3.0f*(float)x/(float)m_width-2.25f;
	m_pointY = -2.5f*(float)y/(float)m_height+1.25f;

	((CJulia *)m_juliaObject)->SetSeed(m_pointX, m_pointY);
	m_juliaObject->Compute(0,1);
	InvalidateRect(m_hwndCtrl, NULL, false);
	UpdateWindow(m_hwndCtrl);
	PostMessage(m_hwndParent, WM_UPDATEPOSITION, WPARAM(m_pointX*100000), LPARAM(m_pointY*100000));
}

void CControlMand::DrawSelection(HDC hdc)
{
	HPEN hPen, hpOld;
	hPen = CreatePen(PS_SOLID, 1, 0x000000FF);
	hpOld = (HPEN)SelectObject(hdc, hPen);

	MoveToEx(hdc, m_mouseX - 6, m_mouseY, NULL);
	LineTo(hdc, m_mouseX - 2, m_mouseY);
	MoveToEx(hdc, m_mouseX + 6, m_mouseY, NULL);
	LineTo(hdc, m_mouseX + 2, m_mouseY);
	MoveToEx(hdc, m_mouseX, m_mouseY - 6, NULL);
	LineTo(hdc, m_mouseX, m_mouseY - 2);
	MoveToEx(hdc, m_mouseX, m_mouseY + 6, NULL);
	LineTo(hdc, m_mouseX, m_mouseY + 2);

	SelectObject(hdc, hpOld);
	DeleteObject(hPen);  
}