#ifndef CCONTROLMAND_H
#define CCONTROLMAND_H

#include "CCustomControl.h"

class CFractal;
class CMandelbrot;

class CControlMand : public CCustomControl
{
private:
	CFractal *m_fractalObject;
	CFractal *m_juliaObject;
	int m_mouseX, m_mouseY;
	long double m_pointX, m_pointY;

	unsigned char *m_image;

 	HWND m_hwndJulia;

	void CreateCustomControl();
	void InitCustomControl();
	
	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK MandWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void OnLButtonDown(int x, int y);
	void OnLButtonUp(int x, int y);
	void OnMouseMove(int x, int y);

	void DrawSelection(HDC hdc);
public:
	CControlMand(HWND hwndParent, HWND hwndJulia, CFractal *julia, CMandelbrot *def = NULL);
	virtual ~CControlMand();

	CFractal *GetFractalObject() { return m_fractalObject; };
	void SetPointPossition(long double x, long double y);
	double GetPointX() { return m_pointX; };
	double GetPointY() { return m_pointY; };
};

#endif // CCONTROLMAND_H
