#ifndef CCONTROLPREVIEW_H
#define CCONTROLPREVIEW_H

#define FRACTAL_TYPE_MAND 0
#define FRACTAL_TYPE_JULIA 1

#include "CCustomControl.h"

class CFractal;
class CMandelbrot;

class CControlPreview : public CCustomControl
{
private:
	CFractal *m_fractalObject;
	int m_fractalType;

	unsigned char *m_image;

	int m_drag_x_s;
	int m_drag_y_s;
	int m_drag_x_e;
	int m_drag_y_e;
	bool m_dragging;

	void CreateCustomControl();
	void InitCustomControl();

	void DrawSelection(HDC hdc);

	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CustWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
public:
	CControlPreview(HWND hwndParent, unsigned char *palette, int palSize, double indexVal, double indexInc, bool mand);
	virtual ~CControlPreview();

	void OnRButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonUp(WPARAM wParam, LPARAM lParam);
	void OnMouseMove(WPARAM wParam, LPARAM lParam);
	void OnKeyPress(WPARAM wParam);
	void IncreaseIterationCount();
	void DecreaseIterationCount();
	int GetIterationCount();
	void SetData(CMandelbrot *data);
	void SetCurrentMandelbrot();
	void SetCurrentJulia(float x, float y);
	int GetFractalType() { return m_fractalType; };
	void SetPalette(unsigned char *palette, int palSize, double indexVal, double indexInc);
	void SetSmooth(bool smooth);
	void SetIterationCount(int iterations);
};

#endif // CCONTROLPREVIEW_H
