#include "CCustomColorControl.h"

CCustomColorControl::CCustomColorControl(HWND hwnd):CCustomControl(hwnd)
{}

void CCustomColorControl::HSV2RGB(float h, float s, float v, rgb *r)
{
	int i;
	float f, p, q, t;

	if(s == 0)
	{
		// achromatic (grey)
		r->b = r->g = r->r = (unsigned char)v*255;
		return;
	}

	h *= 6;			// sector 0 to 5
	i = (int)h;
	f = h - i;			// factorial part of h
	p = v*(1 - s);
	q = v*(1 - s*f);
	t = v*(1 - s*(1 - f));

	switch( i ) {
		case 0:
			r->r = unsigned char(v*255);
			r->g = unsigned char(t*255);
			r->b = unsigned char(p*255);
			break;
		case 1:
			r->r = unsigned char(q*255);
			r->g = unsigned char(v*255);
			r->b = unsigned char(p*255);
			break;
		case 2:
			r->r = unsigned char(p*255);
			r->g = unsigned char(v*255);
			r->b = unsigned char(t*255);
			break;
		case 3:
			r->r = unsigned char(p*255);
			r->g = unsigned char(q*255);
			r->b = unsigned char(v*255);
			break;
		case 4:
			r->r = unsigned char(t*255);
			r->g = unsigned char(p*255);
			r->b = unsigned char(v*255);
			break;
		default:		// case 5:
			r->r = unsigned char(v*255);
			r->g = unsigned char(p*255);
			r->b = unsigned char(q*255);
			break;
	}
}

void CCustomColorControl::RGB2HSV(unsigned char red, unsigned char green, unsigned char blue, hsv *c)
{
	float min, max, delta;
	float r = (float)red/255.0f;
	float g = (float)green/255.0f;
	float b = (float)blue/255.0f;

	min = r < g?r:g;
	min = min < b?min:b;
	max = r > g?r:g;
	max = max > b?max:b;

	c->v = max;				// v

	delta = max - min;

	if( max != 0 )
		c->s = delta / max;		// s
	else {
		c->s = 0;
		c->h = 0;
		return;
	}

	if(delta == 0)
	{
		c->h = 0;
		return;
	}

	if( r == max )
		c->h = ( g - b ) / delta;		// between yellow & magenta
	else if( g == max )
		c->h = 2 + ( b - r ) / delta;	// between cyan & yellow
	else
		c->h = 4 + ( r - g ) / delta;	// between magenta & cyan

	c->h /= 6;				
	if( c->h < 0 )
		c->h += 1;
}