#ifndef CCUSTOMCONTROL_H
#define CCUSTOMCONTROL_H

#include "windows.h"
#include <tchar.h>

class CCustomControl
{
protected:
	TCHAR *m_className;
	HWND m_hwndParent;
	HWND m_hwndCtrl;

	HBITMAP m_hBitmap;
	BITMAPINFOHEADER m_bitmapInfo; 

	int m_width;
	int m_height;

	virtual void CreateCustomControl() = 0;
	void InitCustomControl();

	void OnPaint(HDC hdc);
	virtual void DrawSelection(HDC hdc){};
public:
	CCustomControl(HWND hwnd);
	HWND GetHandle() { return m_hwndCtrl; };
};

#endif //CCUSTOMCONTROL_H