#ifndef CFRACTAL_H
#define CFRACTAL_H

#include "windows.h"

#define WM_CALCUPDATE	WM_APP + 0x161
#define WM_CALCDONE		WM_APP + 0x163
#define COLORING_NORMAL	0
#define COLORING_SMOOTH 1
#define PALETTE_CUSTOM	-1

struct possition
{
	long double xMin;
	long double xMax;
	long double yMin;
	long double yMax;
	long double zoomDepth;
};

class CAnimObject;
class CThreadManager;

extern CThreadManager *threadManager;

class CFractal
{
protected:
	unsigned char *m_fractal;
	unsigned char *m_fractalOrig;

	unsigned char **m_fractalBuffer;
	possition *m_positionBuffer;
	int m_bufferSize;
	int m_bufferPointer;
	int m_bufferedFractalCount;
	int m_sizeX;					
	int m_sizeY;
	int m_blurStrength;

	bool m_done;
	bool m_aborted;					// flag indicating that computation should be aborted
	int m_coloringMethod;
	HWND m_hwnd;

	int m_paletteCount;	
	int *m_paletteSize;
	int m_actualPaletteIndex;
	int m_actualPaletteSize;
	double m_actualIndexValue;
	double m_actualIndexIncrement;
	unsigned char *m_actualPalette;
	unsigned char **m_palette;
	int m_customPaletteSize;
	unsigned char *m_customPalette;
	double *m_indexValue;
	double *m_indexIncrement;
	double m_customIndexValue;
	double m_customIndexIncrement;
	void SetPixel(int x, int y, double dist);
	double GetIndexValue(int i);
	static CFractal *m_this;		// this pointer for static member function needed for multithreading

	virtual void CreateDefPalette() = 0;
public:
	CAnimObject *m_animObj;
	
	long double m_zoomDepth;
	long double m_xMin;
	long double m_xMax;
	long double m_yMin;
	long double m_yMax;
	long double m_exp;					//exponent
	int m_iterationCount;
	CFractal(HWND hwnd = NULL);
	CFractal(int width, int height, HWND hwnd);
	~CFractal();
	unsigned char *GetImage() { return m_fractal; };
	virtual void Compute() = 0;
	virtual void Compute(int y, int n) = 0;
	bool ZoomIn(int x1, int y1, int x2, int y2);
	// returns true if there is need to recompute image (out of buffer)
	bool ZoomOut();
	void Clear();
	int GetSizeX() { return m_sizeX; };
	int GetSizeY() { return m_sizeY; };
	void SetSize(int x, int y);
	void SetIterationCount(int count) { if(count > 1) m_iterationCount = count; };
	int GetIterationCount() { return m_iterationCount; };
	void SetFractal(long double x, long double y, int iter, long double zoom, long double exp);
	void SetTexture(unsigned char *texture, int size) { memcpy(m_fractal, texture, size); };
	void Abort() { m_aborted = true; };
	void SetBlurStrength(int blurStrength);
	int GetBlurStrength() { return m_blurStrength; };
	virtual void Reset() {};
	bool IsDone() { return m_done; };								// returns status of compute() functions
	void SetHWND(HWND hwnd) { m_hwnd = hwnd; };
	void BlurImage();

	void SetColoring(int c) { m_coloringMethod = c; };
	int GetColoring() { return m_coloringMethod; };

	unsigned char *GetPalette(int i) { return m_palette[i]; };
	int GetPaletteCount() { return m_paletteCount; };
	int GetPaletteSize(int i) { return m_paletteSize[i]; };
	unsigned char *GetCustomPalette() { return m_customPalette; };
	int GetCustomPaletteSize() { return m_customPaletteSize; };
	void SetCustomPalette(unsigned char *pal, int size);
	void SetActualPalette(int i);
	unsigned char *GetActualPalette() { return m_actualPalette; };
	int GetActualPaletteSize() { return m_actualPaletteSize; };
	int GetActualPaletteIndex() { return m_actualPaletteIndex; };
	double GetActualPaletteIncrement() { return m_actualIndexIncrement; }
	double GetActualPaletteIndexValue() { return m_actualIndexValue; };

	void SetCustomIndexValue(double i) { m_customIndexValue = i; };
	void SetCustomIndexIncrement(double i) {m_customIndexIncrement = i; };
	double GetCustomIndexValue() { return m_customIndexValue; };
	double GetCustomIndexIncrement() {return m_customIndexIncrement; };

	void SetMemoryLocation(unsigned char *loc) { m_fractal = loc; };
	void CopyToLocation(unsigned char *loc);
};

typedef struct complex{
	long double r, i;
}complex;

void Power(complex *c, long double exp);

#endif //CFRACTAL_H