#include "CJulia.h"
#include "math.h"
#include "CThreadManager.h"

CJulia::CJulia(HWND hwnd, CJulia *model) : CFractal(hwnd) 
{
	if(model == NULL)
	{
		m_zoomDepth = 1;
		m_xMin = -1.5;
		m_xMax = 1.5;
		m_yMax = 1.25;
		m_yMin = -1.25;
		m_iterationCount = 128;
		m_exp = 2;
		m_z.r = -0.4;
		m_z.i = 0.6;
		CreateDefPalette();
		SetActualPalette(m_actualPaletteIndex);
		m_customIndexValue = 0.0f;
		m_customIndexIncrement = 0.0f;
	}
	else
	{
		m_zoomDepth = model->m_zoomDepth;
		m_iterationCount = model->m_iterationCount;
		m_exp = model->m_exp;
		m_xMin = model->m_xMin;
		m_xMax = model->m_xMax;
		m_yMax = model->m_yMax;
		m_yMin = model->m_yMin;
		m_z.r = model->GetSeed().r;
		m_z.i = model->GetSeed().i;
		m_blurStrength = model->GetBlurStrength();
		m_coloringMethod = model->GetColoring();
		CreateDefPalette();
		SetCustomPalette(model->GetCustomPalette(), model->GetCustomPaletteSize());
		SetActualPalette(model->GetActualPaletteIndex());
		m_customIndexValue = model->GetCustomIndexValue();
		m_customIndexIncrement = model->GetCustomIndexIncrement();
	}
}

CJulia::CJulia(int width, int height, HWND hwnd, CJulia *model) : CFractal(width, height, hwnd)
{
	if(model == NULL)
	{
		m_zoomDepth = 1;
		m_xMin = -1.5;
		m_xMax = 1.5;
		m_yMax = 1.25;
		m_yMin = -1.25;
		m_iterationCount = 128;
		m_exp = 2;
		m_z.r = -0.4;
		m_z.i = 0.6;
		CreateDefPalette();
		SetActualPalette(m_actualPaletteIndex);
	}
	else
	{
		m_zoomDepth = model->m_zoomDepth;
		m_iterationCount = model->m_iterationCount;
		m_exp = model->m_exp;
		m_xMin = model->m_xMin;
		m_xMax = model->m_xMax;
		m_yMax = model->m_yMax;
		m_yMin = model->m_yMin;
		m_z.r = model->GetSeed().r;
		m_z.i = model->GetSeed().i;
		m_blurStrength = model->GetBlurStrength();
		m_coloringMethod = model->GetColoring();
		CreateDefPalette();
		SetCustomPalette(model->GetCustomPalette(), model->GetCustomPaletteSize());
		SetActualPalette(model->GetActualPaletteIndex());
		m_customIndexValue = model->GetCustomIndexValue();
		m_customIndexIncrement = model->GetCustomIndexIncrement();
	}
}

void CJulia::InitPosition()
{
	m_xMin = -1.5;
	m_xMax = 1.5;
	m_yMax = 1.25;
	m_yMin = -1.25;

}
void CJulia::Reset()
{
	m_exp = 2;
	m_zoomDepth = 1;
	m_z.r = -0.4;
	m_z.i = 0.6;
	m_xMin = -1.5;
	m_xMax = 1.5;
	m_yMax = 1.25;
	m_yMin = -1.25;
	m_iterationCount = 128;
}

void CJulia::Compute()
{
	threadManager->ClearTasks();
	threadManager->AddTask(this, ALL_THREADS);
	threadManager->RunTasks();
}

void CJulia::Compute(int index, int count)
{
	int i;
	complex c;
	m_done = false;
	double magnC, i2;
	int counter = 0;
	
	for(int x = index; x < m_sizeX; x+=count)
	{
		for(int y = 0; y < m_sizeY; y++)
		{
			if(m_aborted)
				break;
			
			counter = 0;
			c.r = m_xMin + (x/(long double)m_sizeX)*(m_xMax - m_xMin);
			c.i = m_yMin + (y/(long double)m_sizeY)*(m_yMax - m_yMin);
			for(i = 0; i < m_iterationCount; i++){
				Power(&c, m_exp);
				c.r += m_z.r;
				c.i += m_z.i;
				if(counter > 0 || (c.r*c.r + c.i*c.i) > 4)
				{
					counter++;
				}
				if(counter > 5)
					break;
			}
			if(i == m_iterationCount)
			{
				i2 = -1;
			}
			else
			{
				if(m_coloringMethod == COLORING_NORMAL || m_exp != 2)
				{
					i2 = i;
				}
				else
				{
					magnC = sqrt(c.r*c.r + c.i*c.i);
					i2 = i + 1 - log(log(magnC))/ log(m_exp);
				}
			}
			SetPixel(x, y, i2);
		}
		if((x % (m_sizeX/10)) == 0)
			SendMessage(m_hwnd, WM_CALCUPDATE, 0, 0);
	}
	SendMessage(m_hwnd, WM_CALCDONE, 0, 0);
	m_done = true;
	m_aborted = false;
}

void CJulia::SetBlurStrength(int blurStrength)
{
	m_blurStrength = blurStrength;
	if(blurStrength == 0)
		Compute();
	else
		BlurImage();
}

void CJulia::CreateDefPalette()
{
	m_paletteCount = 2;

	m_paletteSize = new int[m_paletteCount];
	m_paletteSize[0] = 9;
	m_paletteSize[1] = 21;

	m_palette = new unsigned char*[m_paletteCount];

	m_palette[0] = new unsigned char[m_paletteSize[0]];
	m_palette[1] = new unsigned char[m_paletteSize[1]];

	m_palette[0][0] = 255;
	m_palette[0][1] = 255;
	m_palette[0][2] = 255;
	m_palette[0][3] = 199;
	m_palette[0][4] = 21;
	m_palette[0][5] = 133;
	m_palette[0][6] = 199;
	m_palette[0][7] = 21;
	m_palette[0][8] = 133;

	m_palette[1][0] = 42;
	m_palette[1][1] = 233;
	m_palette[1][2] = 255;
	m_palette[1][3] = 194;
	m_palette[1][4] = 199;
	m_palette[1][5] = 78;
	m_palette[1][6] = 252;
	m_palette[1][7] = 153;
	m_palette[1][8] = 59;
	m_palette[1][9] = 244;
	m_palette[1][10] = 16;
	m_palette[1][11] = 141;
	m_palette[1][12] = 235;
	m_palette[1][13] = 19;
	m_palette[1][14] = 255;
	m_palette[1][15] = 42;
	m_palette[1][16] = 233;
	m_palette[1][17] = 255;
	m_palette[1][18] = 0;
	m_palette[1][19] = 16;
	m_palette[1][20] = 200;

	m_customPaletteSize = 9;
	m_customPalette = new unsigned char[m_customPaletteSize];

	m_customPalette[0] = 255;
	m_customPalette[1] = 255;
	m_customPalette[2] = 255;
	m_customPalette[3] = 199;
	m_customPalette[4] = 21;
	m_customPalette[5] = 133;
	m_customPalette[6] = 199;
	m_customPalette[7] = 21;
	m_customPalette[8] = 133;


	m_customIndexIncrement = 0.0f;
	m_customIndexValue = 0.0f;
	
	m_indexIncrement = new double[m_paletteCount];
	m_indexValue = new double[m_paletteCount];

	m_indexIncrement[0] = 0.0f;
	m_indexIncrement[1] = 10.0f;

	m_indexValue[0] = 0.0f;
	m_indexValue[1] = 10.0f;
}