#include "StdAfx.h"
#include "CMandelbrot.h"
#include "math.h"
#include "CThreadManager.h"

CMandelbrot::CMandelbrot(HWND hwnd, CMandelbrot *model) : CFractal(hwnd)
{
	if(model == NULL)
	{
		m_zoomDepth = 1;
		m_xMin = -2.25;
		m_xMax = 0.75;
		m_yMax = 1.25;
		m_yMin = -1.25;
		m_iterationCount = 64;
		m_exp = 2;
		CreateDefPalette();
		SetActualPalette(m_actualPaletteIndex);
	}
	else
	{
		m_zoomDepth = model->m_zoomDepth;
		m_iterationCount = model->m_iterationCount;
		m_exp = model->m_exp;
		m_xMin = model->m_xMin;
		m_xMax = model->m_xMax;
		m_yMax = model->m_yMax;
		m_yMin = model->m_yMin;
		m_blurStrength = model->GetBlurStrength();
		m_coloringMethod = model->GetColoring();
		CreateDefPalette();
		SetCustomPalette(model->GetCustomPalette(), model->GetCustomPaletteSize());
		SetActualPalette(model->GetActualPaletteIndex());
		m_customIndexValue = model->GetCustomIndexValue();
		m_customIndexIncrement = model->GetCustomIndexIncrement();
	}
}

CMandelbrot::CMandelbrot(int width, int height, HWND hwnd, CMandelbrot *model) : CFractal(width, height, hwnd)
{
	if(model == NULL)
	{
		m_zoomDepth = 1;
		m_xMin = -2.25;
		m_xMax = 0.75;
		m_yMax = 1.25;
		m_yMin = -1.25;
		m_iterationCount = 64;
		m_exp = 2;
		CreateDefPalette();
		SetActualPalette(m_actualPaletteIndex);
	}
	else
	{
		m_zoomDepth = model->m_zoomDepth;
		m_iterationCount = model->m_iterationCount;
		m_exp = model->m_exp;
		m_xMin = model->m_xMin;
		m_xMax = model->m_xMax;
		m_yMax = model->m_yMax;
		m_yMin = model->m_yMin;
		m_blurStrength = model->GetBlurStrength();
		m_coloringMethod = model->GetColoring();
		CreateDefPalette();
		SetCustomPalette(model->GetCustomPalette(), model->GetCustomPaletteSize());
		SetActualPalette(model->GetActualPaletteIndex());
		m_customIndexValue = model->GetCustomIndexValue();
		m_customIndexIncrement = model->GetCustomIndexIncrement();
	}
}

void CMandelbrot::Compute()
{
	threadManager->ClearTasks();
	threadManager->AddTask(this, ALL_THREADS);
	threadManager->RunTasks();
}

void CMandelbrot::Compute(int index, int count)
{
	int i;
	complex c, z;
	m_done = false;
	double magnC, i2;
	int counter = 0;
	
	for(int x = index; x < m_sizeX; x+=count)
	{
		for(int y = 0; y < m_sizeY; y++)
		{
			if(m_aborted)
				break;
			
			counter = 0;
			// convert screen coordinates to fractal coordinates
			c.r = m_xMin + (x/(long double)m_sizeX)*(m_xMax - m_xMin);
			c.i = m_yMin + (y/(long double)m_sizeY)*(m_yMax - m_yMin);
			z.r = c.r;
			z.i = c.i;
			for(i = 0; i < m_iterationCount && !m_aborted; i++)
			{
				Power(&c, m_exp);
				c.r += z.r;
				c.i += z.i;
				//if(sqrt(c.r*c.r + c.i*c.i) > 2)
				if(counter > 0 || (c.r*c.r + c.i*c.i) > 4)
					counter++;
				if(counter > 5)
					break;
			}
			if(i == m_iterationCount)
				i2 = -1;
			else
			{
				if(m_coloringMethod == COLORING_NORMAL || m_exp != 2)
					i2 = i;
				else
				{
					magnC = sqrt(c.r*c.r + c.i*c.i);
					i2 = i + 1 - log(log(magnC))/ log(m_exp);
				}
			}
			
			SetPixel(x, y, i2);
		}
		if((x % (m_sizeX/10)) == 0)
		{
			SendMessage(m_hwnd, WM_CALCUPDATE, 0, 0);
		}
	}
	if(!m_aborted)
		BlurImage();
	PostMessage(m_hwnd, WM_CALCDONE, 0, 0);
	m_done = true;
	m_aborted = false;
}

void CMandelbrot::Reset()
{
	m_zoomDepth = 1;
	m_xMin = -2.25;
	m_xMax = 0.75;
	m_yMax = 1.25;
	m_yMin = -1.25;
	m_iterationCount = 64;
	m_exp = 2;
}

void CMandelbrot::CreateDefPalette()
{
	m_paletteCount = 3;

	m_paletteSize = new int[m_paletteCount];
	m_paletteSize[0] = 18;
	m_paletteSize[1] = 18;
	m_paletteSize[2] = 24;

	m_palette = new unsigned char*[m_paletteCount];
	m_palette[0] = new unsigned char[m_paletteSize[0]];
	m_palette[1] = new unsigned char[m_paletteSize[1]];
	m_palette[2] = new unsigned char[m_paletteSize[2]];

	m_palette[0][0] = 0;
	m_palette[0][1] = 0;
	m_palette[0][2] = 135;
	m_palette[0][3] = 176;
	m_palette[0][4] = 226;
	m_palette[0][5] = 255;
	m_palette[0][6] = 255;
	m_palette[0][7] = 200;
	m_palette[0][8] = 0;
	m_palette[0][9] = 125;
	m_palette[0][10] = 0;
	m_palette[0][11] = 0;
	m_palette[0][12] = 0;
	m_palette[0][13] = 0;
	m_palette[0][14] = 135;
	m_palette[0][15] = 0;
	m_palette[0][16] = 0;
	m_palette[0][17] = 0;

	m_palette[1][0] = 50;
	m_palette[1][1] = 0;
	m_palette[1][2] = 0;
	m_palette[1][3] = 255;
	m_palette[1][4] = 0;
	m_palette[1][5] = 0;
	m_palette[1][6] = 255;
	m_palette[1][7] = 200;
	m_palette[1][8] = 0;
	m_palette[1][9] = 125;
	m_palette[1][10] = 0;
	m_palette[1][11] = 0;
	m_palette[1][12] = 50;
	m_palette[1][13] = 0;
	m_palette[1][14] = 0;
	m_palette[1][15] = 0;
	m_palette[1][16] = 0;
	m_palette[1][17] = 0;

	m_palette[2][0] = 110;
	m_palette[2][1] = 232;
	m_palette[2][2] = 34;
	m_palette[2][3] = 217;
	m_palette[2][4] = 255;
	m_palette[2][5] = 81;
	m_palette[2][6] = 255;
	m_palette[2][7] = 0;
	m_palette[2][8] = 0;
	m_palette[2][9] = 125;
	m_palette[2][10] = 0;
	m_palette[2][11] = 0;
	m_palette[2][12] = 149;
	m_palette[2][13] = 20;
	m_palette[2][14] = 255;
	m_palette[2][15] = 12;
	m_palette[2][16] = 255;
	m_palette[2][17] = 174;
	m_palette[2][18] = 110;
	m_palette[2][19] = 232;
	m_palette[2][20] = 34;
	m_palette[2][21] = 0;
	m_palette[2][22] = 0;
	m_palette[2][23] = 0;

	m_customPaletteSize = 18;
	m_customPalette = new unsigned char[m_customPaletteSize];

	m_customPalette[0] = 0;
	m_customPalette[1] = 0;
	m_customPalette[2] = 135;
	m_customPalette[3] = 176;
	m_customPalette[4] = 226;
	m_customPalette[5] = 255;
	m_customPalette[6] = 255;
	m_customPalette[7] = 200;
	m_customPalette[8] = 0;
	m_customPalette[9] = 125;
	m_customPalette[10] = 0;
	m_customPalette[11] = 0;
	m_customPalette[12] = 0;
	m_customPalette[13] = 0;
	m_customPalette[14] = 135;
	m_customPalette[15] = 0;
	m_customPalette[16] = 0;
	m_customPalette[17] = 0;

	//0, 0, 175,			// blue
	//176, 226, 255,		// very light blue
	//255, 200, 0,			// orange
	//125, 0, 0,			// dark red
	//0, 0, 175

	m_customIndexIncrement = 40.0f;
	m_customIndexValue = 20.0f;

	m_indexIncrement = new double[m_paletteCount];
	m_indexValue = new double[m_paletteCount];

	m_indexIncrement[0] = 40.0f;
	m_indexIncrement[1] = 8.0f;
	m_indexIncrement[2] = 40.0f;

	m_indexValue[0] = 20.0f;
	m_indexValue[1] = 10.0f;
	m_indexValue[2] = 20.0f;
}