#ifndef CMOVEANIMOBJECT_H
#define CMOVEANIMOBJECT_H

#include "CAnimObject.h"

class CAnimationPath;
class CFractal;
class CThreadManager;

extern CThreadManager *threadManager;

class CMoveAnimObject: public CAnimObject
{
private:
	int m_fractalType;
	int m_stepFramesCount;
	int m_stepCount;
	int m_actualStep;
	int m_partialStep;
	CAnimationPath *m_path;
	
public:
	CMoveAnimObject(char fractalType, CAnimationPath *path, int FPS, int stepFrameCount, int stepCount, HWND hwnd, int quality, CFractal *model = NULL);
	~CMoveAnimObject();
	int GetStepFrameCount() { return m_stepFramesCount; };
	void SetStepFramesCount(int n) { m_stepFramesCount = n; };
	int GetStepCount() { return m_stepCount; };
	void Compute();
	void Clear(int quality, int stepframes, CFractal *model = NULL);
};

#endif //CMOVEANIMATIONOBJECT_H