#ifndef COPENGLCONTROLJULIA_H
#define COPENGLCONTROLJULIA_H

#include "windows.h"
#include <tchar.h>

#define PREVIEW_QUALITY_LOW		0
#define PREVIEW_QUALITY_MEDIUM	1
#define PREVIEW_QUALITY_HIGH	2
#define PREVIEW_QUALITY_ANIM	3

class CFractal;
class CJulia;

class COpenGLControlJulia
{
private:
	HWND m_hwndCtrl;
	HWND m_hwndParent;
	HDC	m_hDC;			// GDI Device Context
	HGLRC m_hRC;		// Rendering Context
	TCHAR *m_className;

	int m_width;
	int m_height;
	int m_quality;
	int m_iterationCount;

	long double m_seedX;
	long double m_seedY;

	unsigned int m_texture;
	CJulia *m_fractalObject;

	int InitGL();		
	void Draw();

	void CreateCustomControl();
	int MySetPixelFormat(HDC hdc);
	int OnCreate();
	void InitCustomControl();
	void OnPaint();
			
	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK JuliaWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	COpenGLControlJulia(HWND hwndParent, int quality, long double seedX = -0.4, long double seedY = 0.6);
	virtual ~COpenGLControlJulia();

	CJulia *GetFractalObject() { return m_fractalObject; };
	HWND GetHandle() { return m_hwndCtrl; };
	void SetQuality(int quality);
	void SetSeed(long double x, long double y) { m_seedX = x; m_seedY = y; };
};

#endif // COPENGLCONTROLJULIA_H
