#ifndef COPENGLCONTROLMAND_H
#define COPENGLCONTROLMAND_H

#include "windows.h"
#include <tchar.h>

class CFractal;
class CMandelbrot;

class COpenGLControlMand
{
private:
	unsigned int m_texture;
	CFractal *m_fractalObject;
	CFractal *m_juliaObject;
	int m_mouseX, m_mouseY;
	long double m_pointX, m_pointY;
	int m_width, m_height;

	HWND m_hwndCtrl;
	HWND m_hwndParent;
	HWND m_hwndJulia;
	HDC	m_hDC;		// GDI Device Context
	HGLRC m_hRC;		// Rendering Context
	TCHAR *m_className;// = _T("OpenGLControl");

	int InitGL();	//inicializcia OpenGL
	void Draw();

	void CreateCustomControl();

	int MySetPixelFormat(HDC hdc);
	int OnCreate(CMandelbrot *def);
	void InitCustomControl();
	
	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK MandWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void OnPaint();
	void OnLButtonDown(int x, int y);
	void OnLButtonUp(int x, int y);
	void OnMouseMove(int x, int y);

public:
	COpenGLControlMand(HWND hwndParent, HWND hwndJulia, CFractal *julia, CMandelbrot *def = NULL);
	virtual ~COpenGLControlMand();

	CFractal *GetFractalObject() { return m_fractalObject; };
	HWND GetHandle() { return m_hwndCtrl; };
	void SetPointPossition(long double x, long double y);
	float GetPointX() { return m_pointX; };
	float GetPointY() { return m_pointY; };
};

#endif // COPENGLCONTROLMAND_H
