#ifndef COPENGLCONTROLMANDNURBS_H
#define COPENGLCONTROLMANDNURBS_H

#include "windows.h"
#include <tchar.h>

class CFractal;
class CMandelbrot;
class CNURBS;
class CVertex;

class COpenGLControlMandNURBS
{
private:
	unsigned int m_texture;
	CFractal *m_fractalObject;
	CFractal *m_juliaObject;
	int m_mouseX, m_mouseY;
	float m_pointX, m_pointY;
	int m_width, m_height;

	HWND m_hwndCtrl;
	HWND m_hwndParent;
	HWND m_hwndJulia;
	HDC	m_hDC;		// GDI Device Context
	HGLRC m_hRC;		// Rendering Context
	TCHAR *m_className;// = _T("OpenGLControl");

	CNURBS *m_NURBS;
	bool m_dragging;
	CVertex *m_draggedVertex;
	CVertex *m_toDeleteVertex;
	float m_positionX;
	float m_positionY;
	int m_actualFrame;

	int InitGL();	//inicializcia OpenGL
	void Draw();

	void CreateCustomControl();

	int MySetPixelFormat(HDC hdc);
	int OnCreate(CMandelbrot *def);
	void InitCustomControl();
	
	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK MandWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void OnPaint();
	void OnLButtonDown(int x, int y);
	void OnLButtonUp(int x, int y);
	void OnRButtonDown(int x, int y);
	void OnRButtonUp(int x, int y);
	void OnMouseMove(int x, int y);

public:
	COpenGLControlMandNURBS(HWND hwndParent, HWND hwndJulia, CFractal *julia, CNURBS *nurbs = NULL, CMandelbrot *def = NULL);
	virtual ~COpenGLControlMandNURBS();

	CFractal *GetFractalObject() { return m_fractalObject; };
	HWND GetHandle() { return m_hwndCtrl; };
	void SetPointPossition(float x, float y);
	float GetPointX() { return m_pointX; };
	float GetPointY() { return m_pointY; };
	long double GetFrameSeedX();
	long double GetFrameSeedY();
	void SetStepFrames(int i);
	void SetFrame(int i);
	int GetRange();
	CNURBS *GetNURBSObject() { return m_NURBS; };
};

#endif // COPENGLCONTROLMANDNURBS_H
