#include "COpenGLControlPaletteSlider.h"
#include "CMandelbrot.h"
#include "CJulia.h"
#include "CAnimObject.h"
#include "CAnimationPath.h"
#include "stdio.h"

#include <gl/gl.h>
#include <gl/glu.h>

#pragma comment (lib,"opengl32.lib")
#pragma comment (lib,"glu32.lib")
#pragma comment (lib,"glaux.lib")

LRESULT CALLBACK COpenGLControlPaletteSlider::CustWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	COpenGLControlPaletteSlider *pThis = (COpenGLControlPaletteSlider*)GetProp(hwnd,"ClassPointer");
	if(pThis) 
		return pThis->CustWndProc(hwnd,msg,wParam,lParam);
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

LRESULT COpenGLControlPaletteSlider::CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch(msg)
    {
	case WM_PAINT:
		wglMakeCurrent(m_hDC,m_hRC);
		OnPaint();
		//wglMakeCurrent(NULL,NULL);	//neaktvny render contex
	break;
	//case WM_RBUTTONDOWN:
	//	OnRButtonDown(wParam, lParam);
	//break;
	case WM_LBUTTONDOWN:
		RECT r;
		GetWindowRect(hwnd, &r);
		r.bottom--;
		r.top++;
		r.left++;
		r.right--;
		ClipCursor(&r);
		OnLButtonDown(wParam, lParam);
	break;
	case WM_LBUTTONUP:
		OnLButtonUp(wParam, lParam);
		ClipCursor(NULL);
	break;
	case WM_MOUSEMOVE:
		OnMouseMove(wParam, lParam);
	break;
	case WM_DESTROY:
	 	wglMakeCurrent(NULL,NULL);	//neaktvny render contex
	    wglDeleteContext(m_hRC);		//zmae rendering contex	
		::ReleaseDC(m_hwndCtrl,m_hDC);		//ukon vykreslovanie	
	//	delete m_fractalObject;
	break;
	default:
        break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam);
}

COpenGLControlPaletteSlider::COpenGLControlPaletteSlider(HWND hwndParent)
: m_className(_T("COpenGLControlPaletteSlider")),
  //m_animationStep(0),
  //m_path(NULL),
  m_hwndParent(hwndParent),
  m_v(0.5f),
  //m_fractalType(FRACTAL_TYPE_MAND),
  //m_drag_x_e(0),m_drag_x_s(0),m_drag_y_e(0),m_drag_y_s(0),
  m_dragging(false)
  //m_r(255), m_g(255), m_b(255)
{
	m_palette = new unsigned char [3*256];
	InitCustomControl();
	CreateCustomControl();
	OnCreate();
}

COpenGLControlPaletteSlider::~COpenGLControlPaletteSlider()
{

}

void COpenGLControlPaletteSlider::InitCustomControl()
{
    WNDCLASSEX wc;
    
    wc.cbSize         = sizeof(wc);
    wc.lpszClassName  = m_className;
    wc.hInstance      = GetModuleHandle(0);
    wc.lpfnWndProc    = CustWndProcWrapper;
    wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
    wc.hIcon          = 0;
    wc.lpszMenuName   = 0;
    wc.hbrBackground  = (HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
    wc.style          = CS_OWNDC;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hIconSm        = 0;


    RegisterClassEx(&wc);
}


void COpenGLControlPaletteSlider::CreateCustomControl()
{
	m_hwndCtrl = CreateWindowEx(
                 WS_EX_STATICEDGE, // give it a standard border
                 m_className,
                 _T("OpenGL control color"),
                 WS_VISIBLE | WS_CHILD,
                 278, 190, 18, 258,
                 m_hwndParent,
                 NULL, GetModuleHandle(0), NULL
               );

	SetProp(m_hwndCtrl,"ClassPointer",(HANDLE)this);
}

int COpenGLControlPaletteSlider::MySetPixelFormat(HDC hdc)
{
	    PIXELFORMATDESCRIPTOR *ppfd; 
		int pixelformat; 
 
	    PIXELFORMATDESCRIPTOR pfd = { 
		sizeof(PIXELFORMATDESCRIPTOR),	
        1,									//slo verzie
        PFD_DRAW_TO_WINDOW |				//Pixel Format mus podporova okno...
        PFD_SUPPORT_OPENGL |				//...aj OpenGL
        PFD_DOUBLEBUFFER,					//mus podporova double buffering
        PFD_TYPE_RGBA,						//vyaduje RGBA Format
        32,									//nastav farebn hbku
        0,0,0,0,0,0,						//farebn hbka ignorovan
        8,									//iadny alpha buffer
        0,									//Shift Bit ignorovan
        8,									//iadny Accumulation buffer
        0,0,0,0,							//Accumulation bity ignorovan
        64,									//32 bitov Z-Buffer
        8,									//iadny stencil buffer
        8,									//iadny auxiliary buffer
        PFD_MAIN_PLANE,						//hlavn vykreslovacia vrstva
        0,									//rezervovan
        0,0,0								//Layer Masks ignorovan
    }; 
   
    ppfd = &pfd;
 
    if ( (pixelformat = ChoosePixelFormat(hdc, ppfd)) == 0 ) 
    { 
        ::MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    if (SetPixelFormat(hdc, pixelformat, ppfd) == FALSE) 
    { 
        ::MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK); 
        return FALSE; 
    } 
 
    return TRUE; 
}

int COpenGLControlPaletteSlider::OnCreate() 
{
	m_hDC = GetDC(m_hwndCtrl);
    if(!MySetPixelFormat(m_hDC))
    {
		::MessageBox(::GetFocus(),"MySetPixelFormat Failed!","Error",MB_OK);
		return -1;
    }

	m_hRC = wglCreateContext(m_hDC);
    
	wglMakeCurrent(m_hDC,m_hRC);

	//m_fractalObject = new CMandelbrot();
	
	//if(def != NULL)
	//	m_fractalObject->SetTexture(def->GetImage(), def->GetSizeXc()*def->GetSizeYc()*sizeof(unsigned char)*3);
	//else
	//	m_fractalObject->Compute();

	InitGL();	//inicializcia OpenGL

	OnPaint();
	//PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);

    return 0;
}

int COpenGLControlPaletteSlider::InitGL(void)									
{
	glEnable(GL_TEXTURE_2D);
	glClearColor(1.0f, 1.0f, 1.0f, 0.5f);				// ierne pozadie
	glClearDepth(1.0f);									// Nastav Depth Buffer na 1
	
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
	
	glMatrixMode(GL_PROJECTION);						// Modeling transformation
	glLoadIdentity();									// Reset The View
	glOrtho(0, 1, 0, 1, -1, 1);	

	//glGenTextures(1, &m_texture);
	m_texture = 0;
	glBindTexture(GL_TEXTURE_2D, m_texture);
	
	GeneratePalette(0.0f, 0.5f);
	//glTexImage2D(GL_TEXTURE_2D, 0, 3, m_fractalObject->GetSizeXc(), m_fractalObject->GetSizeYc(), 0, GL_RGB, GL_UNSIGNED_BYTE, m_fractalObject->GetImage());
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	return TRUE;										
}

void COpenGLControlPaletteSlider::OnPaint() 
{
	//glClearColor(m_r, m_g, m_b, 0.0f);
	glClear(GL_COLOR_BUFFER_BIT);	// Vyist obrazovku a Depth Buffer

	Draw();	//kreslenie fraktlu

	SwapBuffers(m_hDC);	//prehod buffery
}


void COpenGLControlPaletteSlider::Draw()	//vykreslenie fraktlu
{
//	glBindTexture(GL_TEXTURE_2D, m_texture);

	glBindTexture(GL_TEXTURE_2D, m_texture);
	glBegin(GL_QUADS);
		glTexCoord2f(1.0f, 1.0f); glVertex2f(0, 1);
		glTexCoord2f(0.0f, 1.0f); glVertex2f(0, 0);
		glTexCoord2f(0.0f, 0.0f); glVertex2f(1, 0);
		glTexCoord2f(1.0f, 0.0f); glVertex2f(1, 1);
	glEnd();
	
	glColor3f(0.0f, 0.0f, 0.0f);
	glBegin(GL_LINES);
		glVertex2f(0.0f, m_v);
		glVertex2f(1.0f, m_v);
	glEnd();
	glColor3f(1.0f, 1.0f, 1.0f);
	/*if(m_dragging)
	{
		glBegin(GL_LINE_LOOP);
			glVertex2f(2*(float)m_drag_x_s/(float)m_fractalObject->GetSizeX() - 1, - 2*(float)m_drag_y_s/(float)m_fractalObject->GetSizeY() + 1);
			glVertex2f(2*(float)m_drag_x_e/(float)m_fractalObject->GetSizeX() - 1, - 2*(float)m_drag_y_s/(float)m_fractalObject->GetSizeY() + 1);
			glVertex2f(2*(float)m_drag_x_e/(float)m_fractalObject->GetSizeX() - 1, - 2*(float)m_drag_y_e/(float)m_fractalObject->GetSizeY() + 1);
			glVertex2f(2*(float)m_drag_x_s/(float)m_fractalObject->GetSizeX() - 1, - 2*(float)m_drag_y_e/(float)m_fractalObject->GetSizeY() + 1);
		glEnd();
	}*/
}

void COpenGLControlPaletteSlider::OnMouseMove(WPARAM wParam, LPARAM lParam)
{
	if(m_dragging)
	{
		//RECT r;
		//GetClientRect(m_hwndCtrl, &r);

		int x = LOWORD(lParam);
		int y = HIWORD(lParam);
		//if(x < 0)
		//	x = 0;
		//if(x > 255)
		//	x = 255;
		//if(y < 0)
		//	y = 0;
		//if(y > 255)
		//	y = 255;

		//SetCursorPos(r.left + x, r.top + y);

		m_v = 1.0f - (float)y/256.0f;
		//OnPaint();
		PostMessage(m_hwndParent, WM_SET_V, m_v*100, NULL);
		//PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);
		//PostMessage(m_hwndParent, WM_PAINT, NULL, NULL);
	}
}

void COpenGLControlPaletteSlider::OnLButtonDown(WPARAM wParam, LPARAM lParam) 
{
	m_dragging = true;
	m_v = 1.0f - (float)HIWORD(lParam)/256.0f;
	//OnPaint();
	PostMessage(m_hwndParent, WM_SET_V, m_v*100, NULL);
	//PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);
	//PostMessage(m_hwndParent, WM_PAINT, NULL, NULL);
}

void COpenGLControlPaletteSlider::OnLButtonUp(WPARAM wParam, LPARAM lParam) 
{
	m_dragging = false;
}

void COpenGLControlPaletteSlider::SetHS(float h, float s)
{
	GeneratePalette(h, s);
	PostMessage(m_hwndCtrl, WM_PAINT, NULL, NULL);
}

void COpenGLControlPaletteSlider::GeneratePalette(float h, float s)
{
	for(int v = 0; v < 256; v++)
	{
		m_palette[3*v] = HSV2R(h, s, (float)v/256.0f);
		m_palette[3*v+1] = HSV2G(h, s, (float)v/256.0f);
		m_palette[3*v+2] = HSV2B(h, s, (float)v/256.0f);
		//m_palette[6*v+3] = 255;
		//m_palette[6*v+4] = 255;
		//m_palette[6*v+5] = 255;
	}
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 256, 1, 0, GL_RGB, GL_UNSIGNED_BYTE, m_palette);
}

unsigned char COpenGLControlPaletteSlider::HSV2R(float h, float s, float v)
{
	int i;
	float f, p, q, t;

	if(s == 0)
	{
		// achromatic (grey)
		return v*255;
	}

	h *= 6;			// sector 0 to 5
	i = (int)h;
	f = h - i;			// factorial part of h
	p = v*(1 - s);
	q = v*(1 - s*f);
	t = v*(1 - s*(1 - f));

	switch( i ) {
		case 0:
			return v*255;
			//*r = v;
			//*g = t;
			//*b = p;
			break;
		case 1:
			return q*255;
			//*r = q;
			//*g = v;
			//*b = p;
			break;
		case 2:
			return p*255;
			//*r = p;
			//*g = v;
			//*b = t;
			break;
		case 3:
			return p*255;
			//*r = p;
			//*g = q;
			//*b = v;
			break;
		case 4:
			return t*255;
			//*r = t;
			//*g = p;
			//*b = v;
			break;
		default:		// case 5:
			return v*255;
			//*r = v;
			//*g = p;
			//*b = q;
			break;
	}
}

unsigned char COpenGLControlPaletteSlider::HSV2G(float h, float s, float v)
{
	int i;
	float f, p, q, t;

	if(s == 0)
	{
		// achromatic (grey)
		return v*255;
	}

	h *= 6;			// sector 0 to 5
	i = (int)h;
	f = h - i;			// factorial part of h
	p = v*(1 - s);
	q = v*(1 - s*f);
	t = v*(1 - s*(1 - f));

	switch( i ) {
		case 0:
			return t*255;
			/**r = v;
			*g = t;
			*b = p;*/
			break;
		case 1:
			return v*255;
			//*r = q;
			//*g = v;
			//*b = p;
			break;
		case 2:
			return v*255;
			//*r = p;
			//*g = v;
			//*b = t;
			break;
		case 3:
			return q*255;
			//*r = p;
			//*g = q;
			//*b = v;
			break;
		case 4:
			return p*255;
			//*r = t;
			//*g = p;
			//*b = v;
			break;
		default:		// case 5:
			return p*255;
			//*r = v;
			//*g = p;
			//*b = q;
			break;
	}
}

unsigned char COpenGLControlPaletteSlider::HSV2B(float h, float s, float v)
{
	int i;
	float f, p, q, t;

	if(s == 0)
	{
		// achromatic (grey)
		return v*255;
	}

	h *= 6;			// sector 0 to 5
	i = (int)h;
	f = h - i;			// factorial part of h
	p = v*(1 - s);
	q = v*(1 - s*f);
	t = v*(1 - s*(1 - f));

	switch( i ) {
		case 0:
			return p*255;
			//*r = v;
			//*g = t;
			//*b = p;
			break;
		case 1:
			return p*255;
			//*r = q;
			//*g = v;
			//*b = p;
			break;
		case 2:
			return t*255;
			//*r = p;
			//*g = v;
			//*b = t;
			break;
		case 3:
			return v*255;
			//*r = p;
			//*g = q;
			//*b = v;
			break;
		case 4:
			return v*255;
			//*r = t;
			//*g = p;
			//*b = v;
			break;
		default:		// case 5:
			return q*255;
			//*r = v;
			//*g = p;
			//*b = q;
			break;
	}
}