#ifndef COPENGLCONTROLSMALL_H
#define COPENGLCONTROLSMALL_H

#include "windows.h"
#include <tchar.h>

#define OGLC_MAND 0
#define OGLC_JULIA 1

class CFractal;

class COpenGLControlMand
{
private:

	HWND m_hwndCtrl;
	unsigned int m_texture;
	
	CFractal *m_fractalObject;
	
	TCHAR *szClassName;// = _T("OpenGLControl");

	HWND m_hwndparent;

	HDC	m_hDC;		// GDI Device Context
	HGLRC m_hRC;		// Rendering Context

	int InitGL();	//inicializcia OpenGL
	void Draw();

	void CreateCustomControl();
	int MySetPixelFormat(HDC hdc);
	int OnCreate();
	void InitCustomControl();
	
	LRESULT CALLBACK CustWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK MandWndProcWrapper(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	
public:
	COpenGLControlMand(HWND hwndParent, int type);
	virtual ~COpenGLControlMand();

	void OnPaint();
	//void OnRButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonUp(WPARAM wParam, LPARAM lParam);
	//void OnKeyPress(WPARAM wParam);
	//void IncreaseIterationCount();
	//void DecreaseIterationCount();
	//void SetCurrentMandelbrot();
	//void SetCurrentJulia();
	//void SaveToBmp(const char *fileName, unsigned char *texture, int width, int height);
	//void DrawAnimation(CAnimObject *animationObject);
	//void SetFPS(int fps);
	//void SetPathObject(CAnimationPath *path) { m_path = path; }; 
	CFractal *GetFractalObject() { return m_fractalObject; };
	HWND GetHandle() { return m_hwndCtrl; };
};

#endif // COPENGLCONTROLSMALL_H
