#ifndef CTHREADMANAGER_H
#define CTHREADMANAGER_H

#include "process.h"
#include <vector>

#define ALL_THREADS -1
#define MULTITHREADING_ENABLED

class CFractal;

struct threadParam
{
	CFractal *fractalHandle;
	int concurentThreads;		// how many threads is working on one image
};

class CThreadManager
{
private:
	unsigned int m_threadCount;
	
	static threadParam *m_params;
	static HANDLE *m_threads;

	static bool *m_threadIdle;
	static int m_taskIndex;
	static int m_taskCount;

	static std::vector<threadParam> m_tasks;

	static DWORD WINAPI ThreadProc(LPVOID param);
	static bool TaskDone(int threadID);

	int GetCoreCount();
public:
	CThreadManager();

	void AddTask(CFractal *f, int concurentThreads);
	void RunTasks();
	void ClearTasks();

	int GetThreadCount() { return m_threadCount; };
	void Abort();
};

#endif //CTHREADMANAGER_H