#ifndef NURBS_H
#define NURBS_H

struct complex;

class CVertex{
private:
	double m_x, m_y;
	CVertex *m_next;
	bool m_selected;
	bool m_hover;
public:
	CVertex();
	CVertex(double x, double y);
	void SetVertex(double x, double y) { 	m_x = x; m_y = y; };
	void SetSelected(bool selected) { m_selected = selected; };
	bool GetSelected() { return m_selected; };
	void SetHover(bool hover) { m_hover = hover; };
	bool GetHover() { return m_hover; };
	CVertex *GetNext() { return m_next; };
	void SetNext(CVertex *n) { m_next = n; };
	double GetX() { return m_x; };
	double GetY() { return m_y; };
};

class CNURBS
{
private:
	int m_vertexCount;
	CVertex *m_firstVertex;
	int m_d;
	int m_m;
	double *m_tVector;

	int m_stepFrames;

	double ComputeN(char i, char k, double t);
	void ComputeS(CVertex *v, double t);
	
public:
	CNURBS();
	void AddPoint(double x, double y);

	// return vertex that is in radius from specified point
	// if there are more points in radius, nearest one is chosen
	// returns NULL if there are no points inside radius
	CVertex *GetNearestPoint(double x, double y);

	complex GetFrame(int i);
	void SetStepFrames(int i) { m_stepFrames = i; };
	int GetFramesCount() { return m_stepFrames*(m_vertexCount-1); };
	int GetStepFrames() { return m_stepFrames; };
	int GetVertexCount() { return m_vertexCount; };
	CVertex *GetVertex(int i);
	// returns true if there was some vertex with hover 
	bool ClearVerticesHover();
	void DeleteVertex(CVertex *v);
};

#endif //NURBS_H