/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.game;

import java.util.HashMap;
import sk.lenhardt.game.Position;

public class WTIAAlgorithm {
    public static final int SUPER_LOOSING = -2;
    public static final int SUPER_WINNING = -1;
    private static HashMap cache = new HashMap();

    public static int getWTIANumber(Position pos) {
        if (cache.containsKey(pos)) {
            return (Integer)cache.get(pos);
        }
        Position[] moves = pos.getAllPossibleMoves();
        if (pos.isFinal()) {
            cache.put(pos, -2);
            return -2;
        }
        HashMap<Integer, Boolean> nimbers = new HashMap<Integer, Boolean>();
        for (int i = 0; i < moves.length; ++i) {
            int posNumber = moves[i].getWTIANumber();
            if (posNumber == -2) {
                cache.put(pos, -1);
                return -1;
            }
            if (posNumber == -1) continue;
            nimbers.put(posNumber, true);
        }
        int ret = 0;
        while (nimbers.containsKey(ret)) {
            ++ret;
        }
        cache.put(pos, ret);
        return ret;
    }
}

