/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.board;

import java.util.Arrays;
import java.util.LinkedList;
import sk.lenhardt.game.Position;

public class BoardPosition
extends Position {
    private static final int INF = -3;
    public static final int KNIGHT = 0;
    private int[] moveXKnight = new int[]{-1, -2, 1, -2};
    private int[] moveYKnight = new int[]{-2, -1, -2, 1};
    public static final int QUEEN = 1;
    private int[] moveXQueen = new int[]{0, -3, -3};
    private int[] moveYQueen = new int[]{-3, 0, -3};
    public static final int ROOK = 2;
    private int[] moveXRook = new int[]{0, -3};
    private int[] moveYRook = new int[]{-3, 0};
    public static final int KING = 3;
    private int[] moveXKing = new int[]{0, -1, -1};
    private int[] moveYKing = new int[]{-1, 0, -1};
    private int[] moveX;
    private int[] moveY;
    private int posX;
    private int posY;
    private int limit;

    public BoardPosition(int figure, int posX, int posY, int limit) {
        this.posX = posX;
        this.posY = posY;
        this.limit = limit;
        if (figure == 0) {
            this.moveX = this.moveXKnight;
            this.moveY = this.moveYKnight;
        } else if (figure == 1) {
            this.moveX = this.moveXQueen;
            this.moveY = this.moveYQueen;
        } else if (figure == 2) {
            this.moveX = this.moveXRook;
            this.moveY = this.moveYRook;
        } else if (figure == 3) {
            this.moveX = this.moveXKing;
            this.moveY = this.moveYKing;
        } else {
            this.moveX = new int[0];
            this.moveY = new int[0];
        }
    }

    public BoardPosition(int figure, int posX, int posY) {
        this(figure, posX, posY, -1);
    }

    public BoardPosition(int[] moveX, int[] moveY, int posX, int posY, int limit) {
        this.posX = posX;
        this.posY = posY;
        this.moveX = moveX;
        this.moveY = moveY;
        this.limit = limit;
    }

    public BoardPosition(int[] moveX, int[] moveY, int posX, int posY) {
        this(moveX, moveY, posX, posY, -1);
    }

    private boolean isLimit(int x, int y) {
        if (this.limit == -1) {
            return true;
        }
        return x < this.limit && y < this.limit;
    }

    public boolean isFinal() {
        Position[] poss = this.getAllPossibleMoves();
        return poss == null || poss.length == 0;
    }

    public Position[] getAllPossibleMoves() {
        LinkedList<BoardPosition> ret = new LinkedList<BoardPosition>();
        for (int i = 0; i < this.moveX.length; ++i) {
            int k;
            int x = this.moveX[i];
            int y = this.moveY[i];
            if (x != -3 && y != -3) {
                if (this.posX + x < 0 || this.posY + y < 0 || !this.isLimit(this.posX + x, this.posY + y)) continue;
                ret.add(new BoardPosition(this.moveX, this.moveY, this.posX + x, this.posY + y, this.limit));
                continue;
            }
            if (x == -3 && y == -3) {
                int maxim = this.posX < this.posY ? this.posX : this.posY;
                for (int k2 = -maxim; k2 < 0; ++k2) {
                    if (this.posX + k2 < 0 || this.posY + k2 < 0 || !this.isLimit(this.posX + k2, this.posY + k2)) continue;
                    ret.add(new BoardPosition(this.moveX, this.moveY, this.posX + k2, this.posY + k2, this.limit));
                }
                continue;
            }
            if (x == -3 && y != -3) {
                for (k = -this.posX; k < 0; ++k) {
                    if (this.posX + k < 0 || this.posY + y < 0 || !this.isLimit(this.posX + k, this.posY + y)) continue;
                    ret.add(new BoardPosition(this.moveX, this.moveY, this.posX + k, this.posY + y, this.limit));
                }
                continue;
            }
            if (x == -3 || y != -3) continue;
            for (k = -this.posY; k < 0; ++k) {
                if (this.posX + x < 0 || this.posY + k < 0 || !this.isLimit(this.posX + x, this.posY + k)) continue;
                ret.add(new BoardPosition(this.moveX, this.moveY, this.posX + x, this.posY + k, this.limit));
            }
        }
        return ret.toArray(new Position[ret.size()]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BoardPosition)) {
            return false;
        }
        BoardPosition pos = (BoardPosition)o;
        return pos.posX == this.posX && pos.posY == this.posY && pos.moveX.equals(this.moveX) && pos.moveY.equals(this.moveY) && pos.limit == this.limit;
    }

    public int hashCode() {
        return Arrays.hashCode(this.moveX) ^ Arrays.hashCode(this.moveY) ^ (this.posX ^ this.posY);
    }
}

