/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.game;

import sk.lenhardt.game.GrundyNumbersAlgorithm;
import sk.lenhardt.game.PositionVisitor;
import sk.lenhardt.game.RemotenessAlgorithm;
import sk.lenhardt.game.SuspenseAlgorithm;
import sk.lenhardt.game.WLAlgorithm;
import sk.lenhardt.game.WTIAAlgorithm;

public abstract class Position {
    public abstract boolean isFinal();

    public abstract Position[] getAllPossibleMoves();

    public boolean isWinning() {
        return WLAlgorithm.isWinning(this);
    }

    public boolean isLosing() {
        return WLAlgorithm.isLosing(this);
    }

    public int getGrundyNumber() {
        return GrundyNumbersAlgorithm.getGrundyNumber(this);
    }

    public int getWTIANumber() {
        return WTIAAlgorithm.getWTIANumber(this);
    }

    public int getRemoteness() {
        return RemotenessAlgorithm.getRemoteness(this);
    }

    public int getSuspense() {
        return SuspenseAlgorithm.getSuspense(this);
    }

    public void draw(PositionVisitor v) {
        v.draw(this);
    }
}

