/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.game;

import java.util.HashMap;
import sk.lenhardt.game.Position;

public class RemotenessAlgorithm {
    private static HashMap cache = new HashMap();

    public static int getRemoteness(Position pos) {
        if (cache.containsKey(pos)) {
            return (Integer)cache.get(pos);
        }
        Position[] moves = pos.getAllPossibleMoves();
        int greatestOdd = -1;
        int leastEven = -1;
        for (int i = 0; i < moves.length; ++i) {
            int val = moves[i].getRemoteness();
            if (val % 2 == 0) {
                if (leastEven != -1 && val >= leastEven) continue;
                leastEven = val;
                continue;
            }
            if (greatestOdd != -1 && val <= greatestOdd) continue;
            greatestOdd = val;
        }
        int ret = 0;
        if (leastEven != -1) {
            ret = leastEven + 1;
        } else if (greatestOdd != -1) {
            ret = greatestOdd + 1;
        }
        cache.put(pos, ret);
        return ret;
    }
}

