/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.game;

import java.util.HashMap;
import sk.lenhardt.game.Position;

public class SuspenseAlgorithm {
    private static HashMap cache = new HashMap();

    public static int getSuspense(Position pos) {
        if (cache.containsKey(pos)) {
            return (Integer)cache.get(pos);
        }
        Position[] moves = pos.getAllPossibleMoves();
        int leastOdd = -1;
        int greatestEven = -1;
        for (int i = 0; i < moves.length; ++i) {
            int val = moves[i].getRemoteness();
            if (val % 2 == 0) {
                if (greatestEven != -1 && val <= greatestEven) continue;
                greatestEven = val;
                continue;
            }
            if (leastOdd != -1 && val >= leastOdd) continue;
            leastOdd = val;
        }
        int ret = 0;
        if (greatestEven != -1) {
            ret = greatestEven + 1;
        } else if (leastOdd != -1) {
            ret = leastOdd + 1;
        }
        cache.put(pos, ret);
        return ret;
    }
}

