/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.sum;

import java.util.LinkedList;
import sk.lenhardt.game.Position;

public class ANDPosition {
    public Position a;
    public Position b;

    public ANDPosition(Position a, Position b) {
        this.a = a;
        this.b = b;
    }

    public Position[] getAllPossibleMoves() {
        if (this.isFinal()) {
            return new Position[0];
        }
        Position[] aMoves = this.a.getAllPossibleMoves();
        Position[] bMoves = this.b.getAllPossibleMoves();
        LinkedList<ANDPosition> ret = new LinkedList<ANDPosition>();
        for (int i = 0; i < aMoves.length; ++i) {
            for (int j = 0; j < bMoves.length; ++j) {
                ret.add(new ANDPosition(aMoves[i], bMoves[j]));
            }
        }
        return ret.toArray(new Position[ret.size()]);
    }

    public int getRemoteness() {
        return Math.min(this.a.getRemoteness(), this.b.getRemoteness());
    }

    public boolean isLosing() {
        return this.getRemoteness() % 2 == 0;
    }

    public boolean isFinal() {
        return this.a.isFinal() || this.b.isFinal();
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ANDPosition)) {
            return false;
        }
        ANDPosition pos = (ANDPosition)o;
        return this.a.equals(pos.a) && this.b.equals(pos.b) || this.a.equals(pos.b) && this.b.equals(pos.a);
    }
}

