/*
 * DotsAndBoxesPositionValue.java
 *
 * Created on Streda, 2006, október 25, 15:52
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.dots;

import sk.lenhardt.game.Position;
import java.util.LinkedList;
import java.util.Arrays;

/**
 *
 * @author rasto
 */
public class DotsAndBoxesPosition extends Position{    
    
    /** Creates a new instance of DotsAndBoxesPosition*/
    public DotsAndBoxesPosition(int x, int y) {
        this.x=x;
        this.y=y;
        this.range=x*(y-1)+y*(x-1);
        this.val = 0;        
    }
    
    public DotsAndBoxesPosition(int x, int y,boolean[] val) {        
        this.x=x;
        this.y=y;
        this.range=x*(y-1)+y*(x-1);        
        for (int i=0;i<val.length;i++) {
            if (val[i]) this.val+=1L<<i;
        }        
    }
    
    public DotsAndBoxesPosition(int x, int y,long val) {        
        this.x=x;
        this.y=y;
        this.range=x*(y-1)+y*(x-1);
        this.val=val;        
    }
    
    /*private void setIndex(int index,boolean value) {
        if (index>=0&&index<range) {
            if (value) {
                if (!getIndex(index)) val+=1L<<index;
            } else {
                if (getIndex(index)) val-=1L<<index; 
            }
        }
    }*/
    
    public boolean getIndex(int index) {
        if (index>=0&&index<range) return (val&(1L<<(index)))!=0;
        return false;
    }
    
    public boolean isFinal() {
        for (int i=0;i<y-1;i++) for (int j=0;j<x-1;j++) {
            int up=(y-1)*j+i+1;
            int down=(y-1)*(j+1)+i+1;
            int left=x*(y-1)+1+i+j*y;
            int right=x*(y-1)+2+i+j*y;
            if (getIndex(up-1)&&getIndex(down-1)&&getIndex(right-1)&&getIndex(left-1)) return true;
        }
        return false;
    }
    
    public Position[] getAllPossibleMoves() {
        if (isFinal()) return new Position[0];
        LinkedList ret= new LinkedList();        
        for (int i=0;i<range;i++) {            
            if (getIndex(i)==false) {                
                long pom = val;
                pom+=1L<<i;                
                ret.add(new DotsAndBoxesPosition(x,y,pom));                
            }
        }
        return (Position[])ret.toArray(new Position[ret.size()]);
    }
    
    public boolean equals(Object o) {
        if (! (o instanceof DotsAndBoxesPosition )) return false;
        DotsAndBoxesPosition pos = (DotsAndBoxesPosition)o;
        if (pos.x==this.x&&pos.y==this.y&&pos.val==this.val) return true;
        return false;
    }
    
    public int hashCode() {
        int ret=x*37^y*17^((int)(val%123472539)); 
        return ret;
    }
    
    public String toString() {
        return "x="+x+" y="+y+" val="+val;
    }
    
    public int getX() {
        return x;        
    }
    
    public int getY() {
        return y;
    }
            
    protected int x;
    
    protected int y;
    
    protected int range;
    
    protected long val;
    
}
