/*
 * DotsAndBoxesUpgradePosition.java
 *
 * Created on Streda, 2007, január 24, 21:50
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.dots;

import sk.lenhardt.dots.DotsAndBoxesPosition;
import sk.lenhardt.game.Position;
import sk.lenhardt.sum.WTIAPosition;
import java.util.LinkedList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ArrayList;


class Pair {
    int x,y;
    Pair(int x,int y) {
        this.x=x;
        this.y=y;
    }
    int getX() {
        return x;
    }
    int getY() {
        return y;
    }
}

/**
 *
 * @author rasto
 */
public class DotsAndBoxesSmallPosition extends DotsAndBoxesPosition {
    
    public DotsAndBoxesSmallPosition(int x, int y, long dis) {
        super(x,y);
        disabled = dis;
    }
    
    public DotsAndBoxesSmallPosition(int x, int y,long val, long dis) {
        super(x,y,val);
        disabled = dis;
    }
    
    
    /*
     * disabled fields
     */
    private long disabled=0;
    
    private int getDisabledNumber(int tx,int ty) {
        return y*tx+ty;
    }    
    
    private boolean getDisabledXY(int tx, int ty) {
        return (disabled&(1L<<getDisabledNumber(tx, ty)))!=0;
    }
    
    private void setDisabled(int tx,int ty) {
        if (!getDisabledXY(tx, ty)) disabled+=1L<<getDisabledNumber(tx,ty);        
    }
                    
    public boolean getIndex(int index) {
        if (index>=0&&index<range) return (val&(1L<<(index)))!=0;
        return false;
    }
    
    public boolean isFinal() {
        for (int i=0;i<y-1;i++) for (int j=0;j<x-1;j++) if (!getDisabledXY(j,i)) {
            int up=(y-1)*j+i+1;
            int down=(y-1)*(j+1)+i+1;
            int left=x*(y-1)+1+i+j*y;
            int right=x*(y-1)+2+i+j*y;
            if (getIndex(up-1)&&getIndex(down-1)&&getIndex(right-1)&&getIndex(left-1)) return true;
        }
        return false;
    }
    
    public Position[] getAllPossibleMoves() {         
        if (isFinal()) return new Position[0];
        LinkedList ret= new LinkedList();        
        HashMap used = new HashMap();
        for (int i=0;i<y-1;i++) for (int j=0;j<x-1;j++) if (!getDisabledXY(j,i)) {
            int pocet=0;
            int up=(y-1)*j+i+1;
            int down=(y-1)*(j+1)+i+1;
            int left=x*(y-1)+1+i+j*y;
            int right=x*(y-1)+2+i+j*y;
            int[] poss = {up,down,left,right};
            for (int k=0;k<poss.length;k++) if (!used.containsKey(Integer.valueOf(poss[k]))&&!getIndex(poss[k]-1)){
                used.put(Integer.valueOf(poss[k]), null);
                                
                // BFS and if needed then normalize                
                
                int[][] plan = new int[y-1][x-1];
                for (int ii=0;ii<y-1;ii++) for (int jj=0;jj<x-1;jj++) plan[ii][jj]=-1;
                int actual=-1;
                for (int ii=0;ii<y-1;ii++) for (int jj=0;jj<x-1;jj++) if (plan[ii][jj]==-1&&!getDisabledXY(jj,ii)) {                                        
                    actual++;
                    ArrayList queue = new ArrayList();
                    Pair pair = new Pair(ii, jj);
                    queue.add(pair);
                    plan[ii][jj] = actual;
                    int index = 0;
                    while (index<queue.size()) {
                        Pair tmp = (Pair)queue.get(index);
                        int iii = tmp.getX();
                        int jjj = tmp.getY();
                        int[] poss2 = {(y-1)*jjj+iii+1,(y-1)*(jjj+1)+iii+1,x*(y-1)+1+iii+jjj*y,x*(y-1)+2+iii+jjj*y};                        
                        int[] movex = {0,0,-1,1};
                        int[] movey = {-1,1,0,0};
                        for (int kk=0;kk<movex.length;kk++) {
                            int tmpx = tmp.getX()+movex[kk];
                            int tmpy = tmp.getY()+movey[kk];
                            if (tmpx>=0&&tmpx<y-1&&tmpy>=0&&tmpy<x-1&&plan[tmpx][tmpy]==-1&&!getDisabledXY(tmpy,tmpx)&&!getIndex(poss2[kk]-1)&&poss2[kk]!=poss[k]) {
                                queue.add(new Pair(tmpx,tmpy));
                                plan[tmpx][tmpy]=actual;
                            }
                        }                                                
                        index++;
                    }                    
                }                
                
                // if no decomposition
                if (actual==0) {
                    long pom = val;
                    pom+=1L<<(poss[k]-1);              
                    ret.add(new DotsAndBoxesSmallPosition(x,y,pom,disabled));                
                } else if (actual>0) {
                    //decompose
                    DotsAndBoxesSmallPosition[] pos = new DotsAndBoxesSmallPosition[actual+1];
                    for (int u=0;u<actual+1;u++) {
                        long d = 0;
                        int mini=999,minj=999,maxi=-1,maxj=-1;
                        for (int ii=0;ii<y-1;ii++) for (int jj=0;jj<x-1;jj++) if (plan[ii][jj]!=u) {
                            d+=1L<<getDisabledNumber(jj,ii);                             
                        } else {
                            if (ii<mini) mini=ii;
                            if (ii>maxi) maxi=ii;
                            if (jj<minj) minj=jj;
                            if (jj>maxj) maxj=jj;
                        }
                        // normalize position
                        long pom = val+(1L<<(poss[k]-1));                        
                        int ny=maxi-mini+2;
                        int nx=maxj-minj+2;
                        long nd=0;
                        for (int ii=mini;ii<=maxi;ii++) for (int jj=minj;jj<=maxj;jj++) if (plan[ii][jj]!=u) {
                            nd+=1L<<ny*(jj-minj)+(ii-mini);
                            //getDisabledNumber(jj-minj,ii-mini)
                        }                       
                        long nval=0;
                        for (int ii=mini;ii<=maxi;ii++) for (int jj=minj;jj<=maxj;jj++) if (plan[ii][jj]==u) {
                            int nup=(y-1)*jj+ii+1;
                            int ndown=(y-1)*(jj+1)+ii+1;
                            int nleft=x*(y-1)+1+ii+jj*y;
                            int nright=x*(y-1)+2+ii+jj*y;                            
                            int[] nposs = {nup,ndown,nleft,nright};
                            int nup2=(ny-1)*(jj-minj)+(ii-mini)+1;
                            int ndown2=(ny-1)*((jj-minj)+1)+(ii-mini)+1;
                            int nleft2=nx*(ny-1)+1+(ii-mini)+(jj-minj)*ny;
                            int nright2=nx*(ny-1)+2+(ii-mini)+(jj-minj)*ny;
                            int[] nposs2 = {nup2,ndown2,nleft2,nright2};
                            HashMap nused = new HashMap();
                            for (int kk=0;kk<nposs.length;kk++) {
                                if ( /*getIndex(nposs[kk]-1)*/ (pom&(1L<<(nposs[kk]-1)))!=0 &&!nused.containsKey(Integer.valueOf(nposs[kk]))) {
                                    nused.put(nposs[kk], null);                                    
                                    nval+=1L<<(nposs2[kk]-1);
                                }
                            }
                        }
                        
                        //pos[u] = new DotsAndBoxesSmallPosition(nx,ny, nval ,nd);                                
                        pos[u]=new DotsAndBoxesSmallPosition(x,y,pom,d);
                    }
                    WTIAPosition w = new WTIAPosition(pos[0],pos[1]);
                    for (int q=2;q<pos.length;q++) {
                        w = new WTIAPosition(w,pos[q]);
                    }
                    ret.add(w);
                } else { 
                    System.out.println("error occured in decomposition of DotsAndBoxesSmallPosition");
                }                
                
            }                        
        }                        
        
        
        return (Position[])ret.toArray(new Position[ret.size()]);        
    }
    
    
    public boolean equals(Object o) {
        if (! (o instanceof DotsAndBoxesSmallPosition )) return false;
        DotsAndBoxesSmallPosition pos = (DotsAndBoxesSmallPosition)o;
        if (pos.x==this.x && pos.y==this.y && pos.val==this.val && pos.disabled == this.disabled) return true;
        return false;
    }
    
    public int hashCode() {        
        return super.hashCode()^((int)disabled); 
    }
    
}
