/*
 * ANDposition.java
 *
 * Created on Nedeľa, 2007, apríl 1, 11:01
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.sum;

import sk.lenhardt.game.Position;
import java.util.LinkedList;
/**
 *
 * @author rasto
 */
public class ANDPosition extends Position{
    
     public Position a, b;
    
    /** Creates a new instance of ANDPosition */
    public ANDPosition(Position a,Position b) {
        this.a = a;
        this.b = b;
    }
    
    public Position[] getAllPossibleMoves() {
        if (isFinal()) return new Position[0];
        Position[] aMoves = a.getAllPossibleMoves();
        Position[] bMoves = b.getAllPossibleMoves();
        LinkedList ret= new LinkedList();                
        for (int i=0;i<aMoves.length;i++) {
            for (int j=0;j<bMoves.length;j++) {
                ret.add(new ANDPosition(aMoves[i],bMoves[j]));            
            }
        }        
        return (Position[])ret.toArray(new Position[ret.size()]);                
    }
    
    public int getRemoteness() {
        return Math.min(a.getRemoteness(),b.getRemoteness());
    }
    
    public boolean isLosing() {
        return (getRemoteness()%2==0);
    }
    
    public boolean isFinal() {
        return a.isFinal()||b.isFinal();
    }
    
    public int hashCode() {
        return a.hashCode()^b.hashCode();
    }
    
    public boolean equals(Object o) {
        if (! (o instanceof ANDPosition)) return false;
        ANDPosition pos = (ANDPosition)o;
        return (this.a.equals(pos.a)&&this.b.equals(pos.b))||(this.a.equals(pos.b)&&this.b.equals(pos.a));
    }
    
}
