/*
 * SuspenseAlgorithm.java
 *
 * Created on Pondelok, 2007, marec 12, 22:35
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.game;

import java.util.HashMap;

/**
 *
 * @author rasto
 */
public class SuspenseAlgorithm {
    
    private static HashMap cache = new HashMap();    
    
    public static int getSuspense(Position pos) {
        if (cache.containsKey(pos)) {
            return ((Integer)cache.get(pos)).intValue();
        }
                
        Position[] moves = pos.getAllPossibleMoves();
                
        // -1 means that it is not defined yet
        int leastOdd=-1;
        int greatestEven=-1;
        
        for (int i=0;i<moves.length;i++) {
            int val = moves[i].getRemoteness();
            if (val%2==0) {
                if (greatestEven==-1||val>greatestEven) greatestEven = val;
            } else {
                if (leastOdd==-1||val<leastOdd) leastOdd = val;
            }
        }
        
        int ret=0;
        if (greatestEven!=-1) {
            ret = greatestEven + 1;
        } else if (leastOdd!=-1) {
            ret = leastOdd + 1;
        }
        
        cache.put(pos, Integer.valueOf(ret));
        return ret;        
    }
    
}
