/*
 * WinningAlgorithm.java
 *
 * Created on Streda, 2006, október 25, 16:41
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.game;

import java.util.HashMap;
import sk.lenhardt.dots.DotsAndBoxesVisitorText;
/**
 *
 * @author rasto
 */
public class WLAlgorithm {
    
    private static HashMap cache = new HashMap();
    
    private static int loosing = 0;
    private static int winning = 0;
    
    
    public static boolean isWinning(Position pos) {
        
        if (cache.containsKey(pos)) {
            return ((Boolean)cache.get(pos)).booleanValue();
        }
        
        Position[] moves = pos.getAllPossibleMoves();
        for (int i=0;i<moves.length;i++) {
            if (moves[i].isLosing()) {                
                cache.put(pos, Boolean.TRUE);                
                //System.out.println('');
                winning++;                
                return true;
            }
        }
        //System.out.println(':');
        loosing++;
        //pos.draw(new DotsAndBoxesVisitorText());        
        cache.put(pos, Boolean.FALSE);        
        return false;
    }
    
    public static boolean isLosing(Position pos) {
        return !isWinning(pos);
    }

    public static int getLoosing() {
        return loosing;
    }
    
    public static int getWinning() {
        return winning;
    }    
    
}
