/*
 * LimitedNimPosition.java
 *
 * Created on Pondelok, 2006, november 6, 19:03
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.nimlimited;

import sk.lenhardt.game.Position;
import java.util.LinkedList;
import java.util.Arrays;

/**
 *
 * @author rasto
 */
public class LimitedNimPosition extends Position {
    
    private int n;
    private int[] moves;
    
    /** Creates a new instance of LimitedNimPosition */
    public LimitedNimPosition(int n,int[] moves) {
        this.n = n;
        this.moves = moves;
    }
    
    public LimitedNimPosition(int n,int k) {
        this.n = n;
        moves = new int[k];
        for (int i=0;i<k;i++) moves[i]=i+1;
    }
    
    public boolean isFinal() {
        if (n==0) return true; else return false;
    }
    
    public Position[] getAllPossibleMoves() {
        LinkedList ret= new LinkedList();                
        for (int i=0;i<moves.length;i++) {
            if (n-moves[i]>=0) ret.add(new LimitedNimPosition (n-moves[i],moves));            
        }
        return (Position[])ret.toArray(new Position[ret.size()]);        
    }    
    public boolean equals(Object o) {
        if (! (o instanceof LimitedNimPosition )) return false;
        LimitedNimPosition pos = (LimitedNimPosition)o;
        return (pos.n==this.n&&pos.moves==this.moves);        
    }
    
    public int hashCode() {
        int ret=n^Arrays.hashCode(moves); 
        return ret;
    }
    
}
