<?php

class Graph{
	public $nodes;
	public $nodeCount=0;
	public $edges=array();
	public $edgeCount=0;
	function __construct(){
	}
	public function addNode($name,$mass = 0, $static = false){
		$this->nodes[$name] = new GraphNode($name,$mass, $static);
		$this->nodeCount++;
	}
	public function addEdge($node1,$node2){
		if (($this->nodes[$node1]!=null)&&($this->nodes[$node2]!=null)){
			foreach($this->edges as $edge){
				if ((($edge->nodes[0]->name==$node1)&&($edge->nodes[1]->name==$node2))||(($edge->nodes[0]->name==$node2)&&($edge->nodes[1]->name==$node1))) return;
			}
			$edge = new GraphEdge($this->edgeCount,$this->nodes[$node1], $this->nodes[$node2]);
			$this->edges[$this->edgeCount] = $edge;
			$this->nodes[$node1]->addEdge($edge);
			$this->nodes[$node2]->addEdge($edge);
			$this->edgeCount++;
		}else {
			//echo("error, node doesn't exist\n");
		}
	}
	public function randomize(){
		foreach ($this->nodes as &$node){
			$node->position[0]= rand(0,10000)/10000;
			$node->position[1]= rand(0,10000)/10000;
		}
	}
	public function normalize(){
		$Xmin = 1; $Xmax = 0;
		$Ymin = 1; $Ymax = 0;
		foreach ($this->nodes as &$node){
			$Xmin = min($node->x(),$Xmin);$Xmax = max($node->x(),$Xmax);
			$Ymin = min($node->y(),$Ymin);$Ymax = max($node->y(),$Ymax);
		}
		$dx = $Xmin-(1-($Xmax-$Xmin))/2;
		$dy = $Ymin-(1-($Ymax-$Ymin))/2;
		if (($Xmin!=$Xmax)&&($Ymin!=$Ymax)) //one node situation
		foreach ($this->nodes as &$node){
			$node->position[0] -= $Xmin; 
			$node->position[1] -= $Ymin;
			$node->position[0] *= 1/($Xmax-$Xmin); 
			$node->position[1] *= 1/($Ymax-$Ymin);
			 
		}
	}
	
	public function make(){
		$energy = 1;
		$x = 0;
		while(($energy>0.0000001)&&($x<500)){
			$energy = $this->step(0.15);
			$x++;
			/*
			echo("iteration #".$x." energy: ".$energy."<br/>");
			foreach ($graph->nodes as &$node){
				echo ($node->name.":[".$node->position[0].",".$node->position[1]."]<br/>");
			}
			*/
		}
		//echo("iterations:".$x."<br/>");
	}
	public function step($time = 0.1){
		$damping = 0.9;
		$totalEnergy = 0;
		foreach ($this->nodes as &$node){
			$velocity = array(0,0);
			foreach($this->nodes as $otherNode){
				if ($otherNode!=$node){
					$tmpVelocity = $this->coulombRepulsion($node,$otherNode);
					$velocity[0] += $tmpVelocity[0];
					$velocity[1] += $tmpVelocity[1];					
				}
			}
			foreach($node->edges as $edge){
				$tmpVelocity = $this->hookeAttraction($edge,$node);
				$velocity[0] += $tmpVelocity[0];
				$velocity[1] += $tmpVelocity[1];
			}	
			$node->velocity[0] = ($node->velocity[0] + $time*$velocity[0])*$damping;
			$node->velocity[1] = ($node->velocity[1] + $time*$velocity[1])*$damping;
			$totalEnergy += $node->mass*( pow($node->velocity[0],2)+pow($node->velocity[1],2) );
			
		}
		foreach ($this->nodes as &$node){
			if (!$node->static) {
				$node->position[0] = ($node->position[0] + $time*$node->velocity[0]);
				$node->position[1] = ($node->position[1] + $time*$node->velocity[1]);
			}
		}
		return($totalEnergy);
	}
	
	public function coulombRepulsion($node1,$node2){
		$distance = sqrt(pow($node1->x()-$node2->x(),2)+pow($node1->y()-$node2->y(),2));
		$r[0] = ($node1->x() - $node2->x())/pow($distance,2)*($node1->mass*$node2->mass);
		$r[1] = ($node1->y() - $node2->y())/pow($distance,2)*($node1->mass*$node2->mass);
		return $r;
	}
	public function hookeAttraction($edge,$node){
		if ($edge->nodes[0]==$node) { $node1 = $edge->nodes[0]; $node2 = $edge->nodes[1];}
			else { $node1 = $edge->nodes[1]; $node2 = $edge->nodes[0];}
		$dlength = sqrt(pow($node1->x()-$node2->x(),2)+pow($node1->y()-$node2->y(),2))-$edge->length;
		$distance = sqrt(pow($node1->x()-$node2->x(),2)+pow($node1->y()-$node2->y(),2));
		$r[0] = -1*($node1->x()-$node2->x())/$distance*$dlength;
		$r[1] = -1*($node1->y()-$node2->y())/$distance*$dlength;	
		return $r;
	}
}


class GraphNode{
	public $name;
	public $mass = 0.1;
	public $size = 0;
	public $static;
	public $edges = array();
	public $numEdges = 0;
	public $position=array(0,0);
	public $velocity=array(0,0);
	function __construct($name,$mass = 0.1,$static = false){
		//if ($mass!=0)$this->mass = $mass;
		$this->size = $mass;
		$this->static = $static;
		$this->id = $id;
		$this->name = $name;
	}
	public function x(){
		return $this->position[0];
	}
	public function y(){
		return $this->position[1];
	}
	public function addEdge($edge){
		$this->edges[$this->numEdges++] = $edge;
	}
}


class GraphEdge{
	public $id;
	public $nodes;
	public $length=0.15;
	function __construct($id,$node1,$node2){
		$this->id = $id;
		$this->nodes = array($node1,$node2);
	}

}

?>
