<?php
/************************************************************************
TagBrowser.php - Wassil
**************************************************************************/
/**
 * class TagBrowser
 */
require_once 'Graph.php';

class TagBrowser {
  private $params;
  private $functions;
  /**
  * @return
  * @access public
   */
  public function __construct($params) {
	$this->params=$params;
	$this->functions='
		 declare function local:getAllTags($lang as xs:string) as element(tag)*{
		 	for
				$posts in collection("weblog")/user/blog/post[@status="published"][contains($lang,@lang)],
				$tags in $posts/tags,
				$tag in distinct-values($tags/tag),
				$tagCanonical in collection("weblog")/tags/tag[alt=$tag][normalize-space(data(@canonical))!=""]
                        return <tag id="{$tagCanonical/@id}" post="{$posts/@ID}">{normalize-space(data($tagCanonical/@canonical))}</tag>
		 };
				
		 declare function local:getUserTags($userID as xs:string, $lang as xs:string) as element(tag)*{
		 	
			for
				$posts in collection("weblog")/user[@ID=$userID]/blog/post[@status="published"][contains($lang,@lang)],
				$tags in $posts/tags,
				$tag in distinct-values($tags/tag),
				$tagCanonical in collection("weblog")/tags/tag[alt=$tag]
                        return <tag post="{$posts/@ID}">{normalize-space(data($tagCanonical/@canonical))}</tag>
		 };

		 declare function local:filterRelatedTags($tags as element(tag)*, $tag as xs:string) as element(tag)*{
		 	for 
				$selected in collection("weblog")/tags/tag[@canonical=$tag]
			return
				$tags[@post=$tags[text()=$selected/alt/text()]/data(@post)]
		 };
		 
		 declare function local:filterUserTags($tags as element(tag)*, $user as xs:string) as element(tag)*{
		 	for 
				$userPosts in collection("weblog")/user[info/nick/text()=$user]/blog/post/@ID
			return
				$tags[@post=$userPosts]
		 };

		declare function local:countTags($tags as element(tag)*) as element(tag)*{
			for 
				$tag in distinct-values($tags)
                        order by count($tags[.=$tag]) descending
                        return 
				<tag id="{subsequence($tags[.=$tag]/@id,1,1)}" count="{count($tags[.=$tag])}">{$tag}</tag>
                };

		declare function local:log($n as xs:double) as xs:double{
			if ($n>1) then local:log($n div 3)+1 else 1
		};
	';
  }
  public function getTitleTags(){
  	$xquery=$this->functions.'
		let $tags:=subsequence(local:countTags(local:getAllTags("'.$_SESSION['session']->getLang().'")),1,80)
		let $tags := for $tag in $tags	return <tag count="{$tag/@count}">{$tag/text()}</tag>
                let $maxTagCount := max($tags/@count)
	       	let $minTagCount := min($tags/@count)
                let $tagsResult:= for 
					$tag in $tags
                                  order by lower-case($tag/text()) ascending
                                  return  
				  	<tag percent="{(($tag/@count - $minTagCount)div ($maxTagCount - $minTagCount+1))}">{$tag/text()}</tag>
		return 
	          $tagsResult
       	
	';
	$tags = $GLOBALS['system']->getDB()->fetchNode($xquery);
	return $tags;

  }
 public function getUserTags($userID){
  	$xquery=$this->functions.'
		let $tags:=subsequence(local:countTags(local:getUserTags("'.$userID.'","'.$_SESSION['session']->getLang().'")),1,50)
		(: let $tags := for $tag in $tags	return <tag count="{local:log($tag/@count)}">{$tag/text()}</tag> :)
		    let $tags := for $tag in $tags	return <tag count="{$tag/@count}">{$tag/text()}</tag>
                let $maxTagCount := max($tags/@count)
	          let $minTagCount := min($tags/@count)
                let $tagsResult:= for 
					$tag in $tags
                                  order by lower-case($tag/text()) ascending
                                  return  
				  	<tag percent="{(($tag/@count - $minTagCount)div ($maxTagCount - $minTagCount+1))}">{$tag/text()}</tag>
		return 
                   $tagsResult
	';
	$tags = $GLOBALS['system']->getDB()->fetchNode($xquery);
	return $tags;

  }
  
  private function getTagsLang($lang){
  	$xquery= $this->functions.'
  		let $lang:="'.$lang.'"
		let $tags:= local:getAllTags($lang)
		let $tagDB:=for 
				$tag in distinct-values($tags/text())
			    order by count($tags[text()=$tag]) descending
			    return 
			    	<tag id="{subsequence($tags[.=$tag]/@id,1,1)}" name = "{$tag}">
					{for $tag2 in $tags[text()=$tag] return <post>{data($tag2/@post)}</post>}
				</tag>

		return
			<tags>{$tagDB}</tags>
		';
	$data = $GLOBALS['system']->getDB()->fetchNode($xquery);
  	return $data;
  }
  public function getTags(){
  	$sk = $this->getTagsLang("sk");
  	$en = $this->getTagsLang("en");
 	$ensk = $this->getTagsLang("ensk");

  	$h = fopen("cron/cache/tagBrowserData_sk.xml", "w"); fwrite($h, $sk); fclose($h);
  	$h = fopen("cron/cache/tagBrowserData_en.xml", "w"); fwrite($h, $en); fclose($h);
  	$h = fopen("cron/cache/tagBrowserData_ensk.xml", "w"); fwrite($h, $ensk); fclose($h);
    	
    	$data = "<test>OK</test>";
      return $data;
	
  }

  public function getData(){
  		/*if ($this->params["user"]!="") return($this->getUserTags($this->params["user"]));
  		if ($this->params["cloud"]=="title") return($this->getTitleTags());
  		*/
  		if ($this->params["type"]=="getTags") return($this->getTags());
		
		if ($this->params["limit"]>0) $limit = $this->params["limit"];
			else $limit = 10;
		if ($selectedTag=="") $selectedTag = "_ROOT_";
		$selectedTag = $this->params["tag"];
		$selectedLang = $_SESSION['session']->getLang();
		
		//read cache
		$h = fopen("cron/cache/tagBrowserData_".$selectedLang.".xml", "r");
          	$tags = stream_get_contents($h);
          	fclose($h);
          
		
		$graph = new Graph();
		$graph->addNode($selectedTag);
		//GET TAGS
		$xquery= $this->functions.'
		let $tagDB:='.$tags.'
		let $lang :="'.$selectedLang.'"		
		let $selectedTag :="'.$selectedTag.'"
		return
		 <tags>
		 {if ($selectedTag="_ROOT_") then subsequence($tagDB/tag,1,'.$limit.') 
			else subsequence(
				for $tag in $tagDB/tag[post=$tagDB/tag[@name=$selectedTag]/post]
				return $tag,1,'.$limit.')
		}</tags>
		';
		//GET NODES
		
		$tags = $GLOBALS['system']->getDB()->fetchNode($xquery);
		$xquery = '
		let $tags := '.$tags.'		
		let $nodes :=for $tag in $tags/tag 
			return 
			  <node id="{$tag/@id}" count="{count($tag/post)}" title="{data($tag/@name)}"/>
		let $maxTagCount := max($nodes/@count)
	      let $minTagCount := min($nodes/@count)
            let $nodes :=for $node in $nodes 
			return 
			  <node data="{data($node/@title)},{(($node/@count - $minTagCount)div ($maxTagCount - $minTagCount+1))}"/>
		
		return
              	string-join($nodes/@data,\'|\')
		';	
		$queryResult = $GLOBALS['system']->getDB()->fetchNode($xquery);
		if (strlen($queryResult)!=0){
			$nodes = array();
			$nodes = explode('|',$queryResult);
			foreach($nodes as $node){
				if($node != $selectedTag){
					$nodeParam = explode (',',$node);
					$graph->addNode($nodeParam[0],$nodeParam[1]);
					$graph->addEdge($node,$selectedTag);
				}
			}
		}
		//GET EDGES 
		$xquery='
		let $tags := '.$tags.'	
		let $edges := for $tag in $tags/tag,
				$tag2 in $tags/tag[./post/text()=$tag/post/text()]
				 return <edge nodes="{$tag/@name},{$tag2/@name}" />
		return
                     string-join($edges/@nodes,\'|\')
                ';
		$queryResult = $GLOBALS['system']->getDB()->fetchNode($xquery);
		if (strlen($queryResult)!=0){
			$edges = array();
			$edges = explode('|',$queryResult);
			foreach($edges as $edge){
				$edgeNodes = array();
				$edgeNodes = explode(',',$edge);
				if ($edgeNodes[0]!=$edgeNodes[1]){
					$graph->addEdge($edgeNodes[0],$edgeNodes[1]);
				}
			}
		}

		$graph->randomize();
		$graph->make();
		$graph->normalize();
		
		$result = "";
		foreach ($graph->edges as &$edge){
			$Ax=$edge->nodes[0]->x()*100;
			$Ay=$edge->nodes[0]->y()*100;
			$Bx=$edge->nodes[1]->x()*100;
			$By=$edge->nodes[1]->y()*100;
			$lineLength = sqrt( ($Ax-$Bx)*($Ax-$Bx)+($Ay-$By)*($Ay-$By) );
			$result.="<line>";
			for($i=0; $i<$lineLength; $i+=3 ){
				
    				$result.= "<div style='align:center;position:absolute;left:".($Ax+($Bx-$Ax)*$i/$lineLength)."%;top:".($Ay+($By-$Ay)*$i/$lineLength)."%;width:1px;height:1px;background:#000'></div>";
			}
			$result.="</line>";
		}	
		foreach ($graph->nodes as &$node){
			
			$result.='<node name="'.$node->name.'" size="'.$node->size.'" x="'.$node->x().'" y="'.$node->y().'"/>';		
		}
		
		$result =  "<tagBrowser><graph>".$result."</graph></tagBrowser>";
		return $result;
	} 
}
