import fs from 'fs'
import {
  DATA_PATH,
  LOG_REQUESTS,
  FORCE_REFETCH,
  getCacheConstsHash
} from '../consts'

const cacheMiddleware = (dirName, options = {}) => f => async (...args) => {
  const constsHash = getCacheConstsHash()
  const fileName = args.join('-') || 'data'
  const dirPath = `${DATA_PATH}/${constsHash}/${dirName}`
  const path = `${dirPath}/${fileName}`

  if (!FORCE_REFETCH && !options.refetch && fs.existsSync(path)) {
    const res = fs.readFileSync(path, 'utf-8')
    LOG_REQUESTS && console.log(path, ' --> CACHED :muscle:')
    return JSON.parse(res)
  }

  LOG_REQUESTS &&
    console.log(path, ' --> not found (or forced refetch), fetching ...')
  const res = await f(...args)
  fs.mkdirSync(dirPath, { recursive: true })
  fs.writeFileSync(path, JSON.stringify(res))
  LOG_REQUESTS && console.log(path, ' --> Done.')
  return res
}

export default cacheMiddleware
