import request from './request'
import { BASE_URL, RESULTS_LIMIT, DATA_FREQUENCY } from '../consts'

const requestBuilders = {
  priceData: symbol => timestamp =>
    request({
      uri: `${BASE_URL}/candles/${symbol}`,
      qs: {
        period: DATA_FREQUENCY,
        from: timestamp,
        limit: RESULTS_LIMIT
      },
      json: true
    }),

  symbolDataLength: async symbol =>
    (await request({
      uri: `${BASE_URL}/candles/${symbol}`,
      qs: {
        period: '1M'
      },
      json: true
    })).length
}

export default requestBuilders
