import request from 'request-promise'
import { Semaphore } from 'await-semaphore'

import { LOG_REQUESTS } from '../consts'

const lock = new Semaphore(10)

const sleep = ms => new Promise(resolve => setTimeout(resolve, ms))

const synchronizedRequest = async (...args) => {
  const release = await lock.acquire()
  LOG_REQUESTS && console.log('Fetching request', ...args)

  try {
    const ret = await request(...args)
    return ret
  } catch (e) {
    console.log('Error with request', e.message, e.status, ...args)
    return null
  } finally {
    await sleep(100)
    release()
    LOG_REQUESTS && console.log('Done.')
  }
}

export default synchronizedRequest
