import { isBefore, addMinutes, addHours, addDays, addMonths } from 'date-fns'

import { RESULTS_LIMIT, DATA_FREQUENCY } from '../consts'

const FREQUENCY_TO_INC_FUNCTION = {
  M1: (date, qnt) => addMinutes(date, qnt),
  M3: (date, qnt) => addMinutes(date, 3 * qnt),
  M5: (date, qnt) => addMinutes(date, 5 * qnt),
  M15: (date, qnt) => addMinutes(date, 15 * qnt),
  M30: (date, qnt) => addMinutes(date, 30 * qnt),
  H1: (date, qnt) => addHours(date, qnt),
  H4: (date, qnt) => addHours(date, 4 * qnt),
  D1: (date, qnt) => addDays(date, qnt),
  D7: (date, qnt) => addDays(date, 7 * qnt),
  '1M': (date, qnt) => addMonths(date, qnt)
}

export const getTimestampsBetween = (startDate, endDate, incQuantity) => {
  const ret = []
  let date = startDate
  while (isBefore(date, endDate)) {
    ret.push(date)
    date = FREQUENCY_TO_INC_FUNCTION[DATA_FREQUENCY](
      date,
      incQuantity || RESULTS_LIMIT
    )
  }
  return ret
}
