/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.f5android;

import android.util.Log;
import james.DCTSteganography;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.f5.ortega.HuffmanDecode;

public class Extract {
    private File f;
    private ExtractionListener listener;
    private byte[] carrier;
    private int[] coeff;
    private ByteArrayOutputStream fos;
    private static byte[] deZigZag = new byte[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    DCTSteganography steganograph;

    public Extract(ExtractionListener listener, String f, DCTSteganography steganograph) {
        this(listener, new File(f), steganograph);
    }

    public Extract(ExtractionListener listener, File f, DCTSteganography steganograph) {
        this.steganograph = steganograph;
        this.fos = new ByteArrayOutputStream();
        this.f = f;
        this.listener = listener;
        try {
            FileInputStream fis = new FileInputStream(this.f);
            this.extract(fis, (int)f.length(), this.fos);
        }
        catch (IOException e) {
            Log.e((String)"***** JPEG-STEGO ******", (String)e.toString());
            e.printStackTrace();
        }
    }

    public void extract(InputStream fis, int flength, ByteArrayOutputStream fos) throws IOException {
        this.carrier = new byte[flength];
        fis.read(this.carrier);
        HuffmanDecode hd = new HuffmanDecode(this.carrier);
        Log.d((String)"***** JPEG-STEGO ******", (String)"Huffman decoding starts");
        this.coeff = hd.decode();
        int[] deZigZagCoeff = new int[this.coeff.length];
        for (int i = 0; i < this.coeff.length; ++i) {
            deZigZagCoeff[i] = this.coeff[i - i % 64 + deZigZag[i % 64]];
        }
        this.steganograph.extract(deZigZagCoeff, fos, this.listener);
    }

    public static interface ExtractionListener {
        public void onExtractionResult(ByteArrayOutputStream var1);
    }
}

